//
//  Other.swift


import UIKit

enum Direction: Int {
  case left, right, up, down
}

// schneidet aus einem Bild ein quadratisches Stück
// an der angegebenen Position aus
// (col = Spalte = x, row = Zeile = y,
//  cnt = Anzahl der Spalten/Zeilen)
// Idee: http://stackoverflow.com/questions/39310729
extension UIImage {
  func crop(col: Int, row: Int, cnt: Int) -> UIImage
  {
    // linkes oder oberes Quadrat aus Quelle
    let srcSide = min(self.size.width, self.size.height)
    
    // Größe der Zielquadrats
    let dstSide = srcSide / CGFloat(cnt)
    
    // Startposition für crop
    let x0 = dstSide * CGFloat(col)
    let y0 = dstSide * CGFloat(row)
    let cropRect =
      CGRect(x: x0, y: y0, width: dstSide, height: dstSide)
    
    // UIImage hat keine cropping-Methode, daher
    // muss auf CGImage zurückgegriffen werden
    let cgImg = self.cgImage!.cropping(to: cropRect)
    return UIImage(cgImage: cgImg!,
                   scale: self.scale,
                   orientation: self.imageOrientation)
  }
}

