//  Datei Puzzle.swift


import UIKit

// Klasse zur Speicherung des Puzzlespiels
class Puzzle {
  var size: Int          // Anzahl der Spalten/Zeilen
  var tiles: [[Tile?]]   // Array mit Puzzleteilen
  
  init(size: Int, img: UIImage, vc: ViewController) {
    // Eigenschaften initialisieren
    self.size = size
    tiles = [[Tile?]](repeating: [Tile?](
      repeating: nil, count: size), count: size)
    
    // evt. alte Puzzleteile löschen
    vc.puzzleView.subviews.forEach() { $0.removeFromSuperview() }
    
    for col in 0..<size {
      for row in 0..<size {
        // Ecke rechts unten bleibt frei
        if row == size-1 && col == row { break }
        
        // Puzzlestück einrichten
        let t = Tile()
        t.row = row
        t.col = col
        t.image = img.crop(col: col, row: row, cnt: size)
        t.layer.borderColor = UIColor.lightGray.cgColor
        
        //        // eigenes GestureRecognizer-Objekt für
        //        // jedes Puzzlestück erforderlich!
        //        let gesture = UIPanGestureRecognizer(
        //          target: vc,
        //          action: #selector(ViewController.panTile(recognizer:)))
        //        t.isUserInteractionEnabled = true // damit Recognizer fn.
        //        t.addGestureRecognizer(gesture)
        
        // Tiles in die PuzzleView einfügen
        vc.puzzleView.addSubview(t)
        tiles[col][row] = t
      }
    }
  }
  
  // passt Position und Größe aller Puzzlestücke an
  func setTilesFrame(in view: UIView) {
    for col in 0..<size {
      for row in 0..<size {
        tiles[col][row]?.frame = getRect(col: col, row: row, container: view)
      }
    }
  }
  
  // ermittelt CGRect für Zielposition eines Puzzlesteins innerhalb
  // eines quadratischen Containers
  func getRect(col: Int, row: Int, container: UIView) -> CGRect {
    let side = container.bounds.width / CGFloat(size)
    return CGRect(x: CGFloat(col) * side,
                  y: CGFloat(row) * side,
                  width: side,
                  height: side)
  }
  


}
