



// Datei ViewController.swift

import UIKit

class ViewController: UIViewController {

  // Outlets zum Zugriff auf die Steuerelemente
  @IBOutlet weak var puzzleView: UIView!
  @IBOutlet weak var sizeSegment: UISegmentedControl!
  
  // das Datenmodell der App
  var puzzle: Puzzle!
  
  // bereits vorgesehener Code
  override func viewDidLoad() {
    super.viewDidLoad()
    puzzle = Puzzle(size: 4,
                    img: UIImage(named: "tower-bridge.jpg")!,
                    vc: self)

  }
  
  // in viewDidLoad() ist Layout noch nicht fertig; daher
  // hier Anpassung der Puzzlesteine an endgültige Größe
  override func viewDidAppear(_ animated: Bool) {
    super.viewDidAppear(animated)
    puzzle.setTilesFrame(in: puzzleView)
  }

  // Actions: diese Methoden werden aufgerufen, 
  // wenn ein Button angeklickt wird.
  // Segmented Control zur Größeneinstellung
  @IBAction func changeSize(_ sender: Any) {
    puzzle = Puzzle(size: sizeSegment.selectedSegmentIndex + 3,
                    img: UIImage(named: "tower-bridge.jpg")!,
                    vc: self)
    puzzle.setTilesFrame(in: puzzleView)
  }
  

  // Shuffle-Button
  @IBAction func shuffle(_ sender: Any) {
    print("shuffle-Button")
  }
  
  // Reset-Button
  @IBAction func reset(_ sender: Any) {
    print("reset-Button")
  }

}

