//
//  GiphyTableViewCell.swift
//  HeiseMultipeerConnectivity
//
//  Created by Gero Gerber on 26.02.19.
//  Copyright © 2019 Gero Gerber. All rights reserved.
//

import AVKit
import UIKit

class GiphyTableViewCell: UITableViewCell {
    @IBOutlet var activityIndicator: UIActivityIndicatorView!
    var videoPlayer: AVPlayer?
    var videoLayer: AVPlayerLayer?
    
    func loadVideo(url: URL) {
        reset()
        
        videoPlayer = AVPlayer(url: url)
        videoLayer = AVPlayerLayer(player: videoPlayer)
        videoLayer?.frame = bounds
        layer.addSublayer(videoLayer!)
        
        NotificationCenter.default.addObserver(forName: .AVPlayerItemDidPlayToEndTime, object: self.videoPlayer?.currentItem, queue: .main) { [weak self] _ in
            if let strongSelf = self {
                strongSelf.toggleActivityIndicator(show: false)
                strongSelf.videoPlayer?.seek(to: CMTime.zero)
                strongSelf.videoPlayer?.play()
            }
        }
        
        videoPlayer?.play()
    }
    
    func reset() {
        toggleActivityIndicator(show: true)
        
        videoLayer?.removeFromSuperlayer()
        videoLayer = nil
        videoPlayer = nil
    }
    
    private func toggleActivityIndicator(show: Bool) {
        if show {
            activityIndicator.isHidden = false
            activityIndicator.startAnimating()
        } else {
            activityIndicator.isHidden = true
            activityIndicator.stopAnimating()
        }
    }
}
