//
//  ImageMessageTableViewCell.swift
//  HeiseMultipeerConnectivity
//
//  Created by Gero Gerber on 21.02.19.
//  Copyright © 2019 Gero Gerber. All rights reserved.
//

import UIKit

class ImageMessageTableViewCell: UITableViewCell, MessageTableViewCellProtocol {

    @IBOutlet var messageSender: UILabel!
    @IBOutlet var messageImage: UIImageView!
    @IBOutlet var messageDate: UILabel!
    @IBOutlet var bgView: UIView!
    
    var delegate: MessageTableViewCellDelegate?

    private let dateFormatter = DateFormatter()
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        bgView.layer.cornerRadius = 10
        dateFormatter.dateFormat = "HH:mm:ss"
        
        let tapGesture = UITapGestureRecognizer(target: self, action: #selector(imageViewTapped))
        messageImage.isUserInteractionEnabled = true
        messageImage.addGestureRecognizer(tapGesture)
    }

    func setChatMessage(message: ChatMessage) {
        messageSender.text = message.sentFromLocalDevice ? "You" : message.sender!
        messageDate.text = dateFormatter.string(from: message.date!)        
        messageImage.image = message.photo?.scaleToSize(size: messageImage.bounds.size)
    }
    
    @objc private func imageViewTapped(_ sender: UITapGestureRecognizer) {
        if let imageData = messageImage.image?.jpegData(compressionQuality: 1) {
            let activityController = UIActivityViewController(activityItems: [imageData], applicationActivities: nil)
            activityController.popoverPresentationController?.sourceView = bgView
            delegate?.presentViewController(vc: activityController)
        }
    }
}
