//
//  TextMessageTableViewCell.swift
//  HeiseMultipeerConnectivity
//
//  Created by Gero Gerber on 22.02.19.
//  Copyright © 2019 Gero Gerber. All rights reserved.
//

import UIKit

class TextMessageTableViewCell: UITableViewCell, MessageTableViewCellProtocol {

    @IBOutlet var messageSender: UILabel!
    @IBOutlet var messageText: UITextView!
    @IBOutlet var messageDate: UILabel!
    @IBOutlet var bgView: UIView!
    
    var delegate: MessageTableViewCellDelegate?
    
    private let dateFormatter = DateFormatter()
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        bgView.layer.cornerRadius = 10
        dateFormatter.dateFormat = "HH:mm:ss"
    }

    func setChatMessage(message: ChatMessage) {
        messageSender.text = message.sentFromLocalDevice ? "You" : message.sender!
        messageDate.text = dateFormatter.string(from: message.date!)
        messageText.text = message.text!
    }
}
