//
//  ChatHistory.swift
//  HeiseMultipeerConnectivity
//
//  Created by Gero Gerber on 19.02.19.
//  Copyright © 2019 Gero Gerber. All rights reserved.
//

import Foundation
import MultipeerConnectivity

class ChatHistory {
    
    weak var delegate: ChatHistoryDelegate?
    
    private var chats = [MCSession: [ChatMessage]]()
    
    func addChatMessage(session: MCSession, message: ChatMessage) {
        var messages = chats[session]

        if messages == nil {
            messages = [ChatMessage]()
        }
        
        messages?.append(message)
        
        chats[session] = messages
        
        delegate?.chatMessageAdded(session: session, message: message)
    }
    
    func getMessages(for session: MCSession) -> [ChatMessage]? {
        return chats[session]
    }
}

protocol ChatHistoryDelegate: class {
    func chatMessageAdded(session: MCSession, message: ChatMessage)
}
