//
//  LocalPeer.swift
//  HeiseMultipeerConnectivity
//
//  Created by Gero Gerber on 19.02.19.
//  Copyright © 2019 Gero Gerber. All rights reserved.
//

import Foundation
import MultipeerConnectivity

class LocalPeer {
    var peerId: MCPeerID {
        get {
            return localPeerId
        }
    }
    
    private let localPeerId: MCPeerID
    private let peerIdKey = "localPeerId"
    
    init() {
        // First we try to recreate stored McPeerID
        let defaults = UserDefaults.standard
        
        if let localPeerIdData = defaults.data(forKey: peerIdKey) {
            do {
                if let unarchivedPeerId = try NSKeyedUnarchiver.unarchivedObject(ofClass: MCPeerID.self, from: localPeerIdData) {
                    localPeerId = unarchivedPeerId
                    print("Successfully loaded peer '\(localPeerId.displayName)'")
                    return
                }
            } catch {
                print("Failed to unarchive MCPeerID: \(error.localizedDescription)")
            }
        }
        
        // When there was no stored MCPeerID, create a new one
        localPeerId = MCPeerID(displayName: UIDevice.current.name)
        
        print("Successfully created peer '\(localPeerId.displayName)'")
        
        do {
            let localPeerIdData = try NSKeyedArchiver.archivedData(withRootObject: localPeerId, requiringSecureCoding: false)
            defaults.set(localPeerIdData, forKey: peerIdKey)
            print("Successfully stored peer '\(localPeerId.displayName)'")
        } catch {
            print("Failed to archive MCPeerID: \(error.localizedDescription)")
        }
    }
}
