//
//  ServiceBrowser.swift
//  HeiseMultipeerConnectivity
//
//  Created by Gero Gerber on 19.02.19.
//  Copyright © 2019 Gero Gerber. All rights reserved.
//

import Foundation
import MultipeerConnectivity

class ServiceBrowser: NSObject {
    var peers: Set<MCPeerID> {
        get {
            // Only return a copy here
            return Set<MCPeerID>(foundPeers)
        }
    }
    
    weak var delegate: PeersDelegate?
    
    private let serviceBrowser: MCNearbyServiceBrowser
    private var foundPeers = Set<MCPeerID>()
    
    init(localPeer: LocalPeer, serviceType: String) {
        serviceBrowser = MCNearbyServiceBrowser(peer: localPeer.peerId, serviceType: serviceType)
        super.init()
        serviceBrowser.delegate = self
        serviceBrowser.startBrowsingForPeers()
        
        print("Started browsing for sessions for service type '\(serviceType)'")
    }
    
    func invite(peer: MCPeerID, session: MCSession) {
        serviceBrowser.invitePeer(peer, to: session, withContext: nil, timeout: 0)
    }
}

extension ServiceBrowser: MCNearbyServiceBrowserDelegate {
    func browser(_ browser: MCNearbyServiceBrowser, foundPeer peerID: MCPeerID, withDiscoveryInfo info: [String : String]?) {
        foundPeers.insert(peerID)
        delegate?.peerFound(peerID: peerID)
        print("Found peer '\(peerID.displayName)'")
    }
    
    func browser(_ browser: MCNearbyServiceBrowser, lostPeer peerID: MCPeerID) {
        foundPeers.remove(peerID)
        delegate?.peerLost(peerID: peerID)
        print("Lost peer '\(peerID.displayName)'")
    }
}

protocol PeersDelegate: class {
    func peerFound(peerID: MCPeerID)
    func peerLost(peerID: MCPeerID)
}
