//
//  AddPeerTableViewController.swift
//  HeiseMultipeerConnectivity
//
//  Created by Gero Gerber on 22.02.19.
//  Copyright © 2019 Gero Gerber. All rights reserved.
//

import MultipeerConnectivity
import UIKit

class AddPeerTableViewController: UITableViewController {

    var session: MCSession?
    var multipeerConnectivityProvider: MultipeerConnectivityProvider?
    var displayPeers = [MCPeerID]()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        navigationController?.navigationBar.prefersLargeTitles = true
        title = "Add Peers"
        
        multipeerConnectivityProvider = AppDelegate.shared.multipeerConnectivityProvider
        
        refresh()
    }
    
    override func viewDidAppear(_ animated: Bool) {
        multipeerConnectivityProvider?.sessionsDelegate = self
        multipeerConnectivityProvider?.peersDelegate = self
    }
    
    func refresh() {
        displayPeers = Array(multipeerConnectivityProvider!.remotePeers).filter {
            
            if let session = session {
                return !session.connectedPeers.contains($0)
            }
            
            return false
        }
        
        tableView.reloadData()
    }

    // MARK: - Table view data source

    override func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }

    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return displayPeers.count
    }

    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "PeerTableViewCell", for: indexPath)
        cell.textLabel?.text = displayPeers[indexPath.row].displayName
        return cell
    }
    
    override func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if let session = session {
            multipeerConnectivityProvider?.invite(peer: displayPeers[indexPath.row], to: session)
        }
    }
}

// MARK: - SessionsDelegate

extension AddPeerTableViewController: SessionsDelegate {
    func sessionAdded(session: MCSession) {
        
    }
    
    func sessionRemoved(session: MCSession) {
        
    }
    
    func peerStateChange(peerID: MCPeerID, state: MCSessionState) {
        refresh()
    }
}

extension AddPeerTableViewController: PeersDelegate {
    func peerFound(peerID: MCPeerID) {
        refresh()
    }
    
    func peerLost(peerID: MCPeerID) {
        refresh()
    }
}
