//
//  SessionsTableViewController.swift
//  HeiseMultipeerConnectivity
//
//  Created by Gero Gerber on 19.02.19.
//  Copyright © 2019 Gero Gerber. All rights reserved.
//

import MultipeerConnectivity
import UIKit

class SessionsTableViewController: UITableViewController {

    var multipeerConnectivityProvider: MultipeerConnectivityProvider!
    var sessions = Array<MCSession>()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        multipeerConnectivityProvider = AppDelegate.shared.multipeerConnectivityProvider
        
        navigationController?.navigationBar.prefersLargeTitles = true
        title = "Joined Sessions"
    }
    
    override func viewDidAppear(_ animated: Bool) {
        multipeerConnectivityProvider.sessionsDelegate = self
        refresh()
    }
    
    func refresh() {
        sessions = Array(multipeerConnectivityProvider.sessions)
        tableView.reloadData()
    }

    // MARK: - UITableViewDataSource

    override func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }

    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return sessions.count
    }

    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "SessionCell", for: indexPath)

        cell.textLabel?.text = sessions[indexPath.row].displayName()

        return cell
    }
    
    // MARK: - UIViewController
    
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        if let destination = segue.destination as? SessionViewController {
            if let indexPath = tableView.indexPathForSelectedRow {
                destination.session = sessions[indexPath.row]
            }
        }
    }
}

extension SessionsTableViewController: SessionsDelegate {
    func sessionAdded(session: MCSession) {
        refresh()
    }
    
    func sessionRemoved(session: MCSession) {
        refresh()
    }
    
    func peerStateChange(peerID: MCPeerID, state: MCSessionState) {
        refresh()
    }
}
