import Cocoa
//
//@dynamicMemberLookup
//public struct ProcessWrapper {
//    public subscript(dynamicMember k: String) -> String? {
//        return ProcessInfo.processInfo.environment[k]
//    }
//}
//
//let env = ProcessWrapper()
//
//let path = env.USER
//
//if(env.USER != nil){
//    print(path!)
//}
//
//@dynamicMemberLookup
//class JSONModel {
//    subscript(dynamicMember member: String) -> Any {
//        let properties = ["id"          : "0x1234",
//                          "name"        : "Foo",
//                          "category"    : "Bar",
//                          "number"      : 42] as [String : Any]
//        return properties[member, default: ""]
//    }
//}
//
//class MyObject: JSONModel { }
//
//let object = MyObject()
//print(object.id)
//print(object.name)
//print(object.category)
//print(object.number)

//#####################################################################################

@dynamicCallable
struct Shell {
    func dynamicallyCall(withKeywordArguments args: KeyValuePairs<String, String>) -> String {
        let task = Process()
        if args.first?.key == "cmd" {
            task.launchPath = args[0].value
            if args[1].key == "param" {
                task.arguments = [ args[1].value ]
            }
        }
        
        let pipe = Pipe()
        task.standardOutput = pipe
        task.launch()
        
        let data = pipe.fileHandleForReading.readDataToEndOfFile()
        let output = String(data: data, encoding: String.Encoding.utf8) ?? ""
        return output
    }
    
    func dynamicallyCall(withArguments args: [String]) -> String {
        let task = Process()
        task.launchPath = args[0]
        task.arguments = [ args[1] ]

        let pipe = Pipe()
        task.standardOutput = pipe
        task.launch()

        let data = pipe.fileHandleForReading.readDataToEndOfFile()
        let output = String(data: data, encoding: String.Encoding.utf8) ?? ""
        return output
    }
}

let myShell = Shell()
myShell("/usr/sbin/sysctl", "-a")
myShell("/usr/bin/id", "-A")
myShell(cmd: "/usr/bin/id", param: "-A")


//#####################################################################################

//@dynamicCallable
//struct CallMe {
//    func dynamicallyCall(withArguments args: [Int]) -> Int { return args.count }
//    func dynamicallyCall(withKeywordArguments args: KeyValuePairs<String, Int>) -> Int {
//        print(args)
//        return args.count
//    }
//}
//let c3 = CallMe()
//print(c3())
//print(c3(1, 2, 3))
//print(c3(a: 1, b: 2))


//#####################################################################################

//let number = 42 % 2
//struct Calc {
//    func isMultiple(i : Int, j : Int) -> Bool {
//        if i % j == 0 {
//            return true
//        } else {
//            return false
//        }
//    }
//}
//
//let calculator = Calc()
//print(calculator.isMultiple(i: 42, j: 4))

//print (number)
//print(42.isMultiple(of: 2))
//print(42 % 19)

//
//let name = "Taylor"
//let greeting = #"Hello, \#(name)!"#
//print(greeting)

let foo = "f" as Character
print(foo.isASCII)
let bar = "™" as Character
print(bar.isASCII)

if foo.isASCII {
    print(foo.asciiValue!)
}

let space = "\n" as Character
print(space.isWhitespace)
print(space.isNewline)

let a = "🤪" as Character
let b = "$" as Character
let c = "π" as Character
let d = "a" as Character
let e = "/" as Character
print(a.isSymbol)
print(b.isSymbol)
print(c.isMathSymbol)
print(d.isLetter)
print(e.isMathSymbol)

let f = "." as Character
let g = "?" as Character
let h = ";" as Character
let i = "-" as Character
let j = ":" as Character
print(f.isPunctuation)
print(g.isPunctuation)
print(h.isPunctuation)
print(i.isPunctuation)
print(j.isPunctuation)

let groß = "G" as Character
let klein = "g" as Character
print(groß.isLowercase)
print(groß.isUppercase)
print(klein.isLowercase)
print(klein.isUppercase)

let baz = "a" as Character
print(baz.isCased)


let regex = #"/^#?([a-f0-9]{6}\|[a-f0-9]{3})$/"#

let text = #"""
Guten Tag,
Horst!
"""#

let sql = #"""
SELECT *
FROM trips
ORDER BY duration"
"""#

struct Item {
    var itemID : Int
    
    init?(itemID : Int){
        self.itemID = itemID
    }
    
    func description() throws -> String {
        return "itemID: \(itemID)"
    }
}

let blockchainItem = Item(itemID: 42)
let description = try? blockchainItem?.description()
print(description)


func modifyTwicy(_ value: inout Int, by modifier: (inout Int) -> ()){
    modifier(&value)
    modifier(&value);
}

func testCount() {
    var count = 1
    modifyTwicy(&count, by: { $0 += count})
    print(count)
}
