//
//  PeopleOcclusionViewController.swift
//  HeiseARKit3
//
//  Created by Gero Gerber on 13.03.20.
//  Copyright © 2020 Gero Gerber. All rights reserved.
//

import ARKit
import Combine
import RealityKit
import UIKit

class PeopleOcclusionViewController: UIViewController {

	@IBOutlet var arView: ARView!
	
	override func viewDidAppear(_ animated: Bool) {
		super.viewDidAppear(animated)
		
		guard ARWorldTrackingConfiguration.isSupported &&
			ARWorldTrackingConfiguration.supportsFrameSemantics(.personSegmentationWithDepth) else {
            fatalError("ARWorldTrackingConfiguration with Frame-Semantics .personSegmentationWithDepth is not supported on this device!")
        }
		
		let config = ARWorldTrackingConfiguration()
		config.planeDetection = .horizontal
		config.frameSemantics = .personSegmentationWithDepth
		
		RobotWalking.load_RobotWalkingAsync(completion: { result in
			switch result {
				case .success(let v):
					self.arView.session.run(config, options: .resetTracking)
					self.arView.scene.addAnchor(v)
				case .failure(let error):
					print(error)
				}
		})
	}
	
	@IBAction func captureTouchUpInside() {
	}
}
