// 2020 Richard Kurz, no rights reserved.

#include <Arduino.h>

//#define USE_MAC_LAYOUT 1
#include "LayoutDE.h"

#if defined (__AVR_ATmega32U4__)

#include "USB_ATmega32U4.h"

#elif defined (__AVR_ATtiny85__)

#include "USB_ATtiny85.h"

#elif defined (ESP32)

#include "BLE_ESP32.h"

#else
#error "Unbekannte CPU"
#endif


#include "Analog4x4.h"
//#include "TTP229.h"
//#include "TM1638.h"


void setup()
{
#ifndef __AVR_ATtiny85__

  Serial.begin(115200);

#if defined (__AVR_ATmega32U4__)
  delay (3000);
  // Bei Bedarf kann hier auf den seriellen Monitor gewartet werden.
  //while (!Serial) {}
#endif

  Serial.println("\n\nHello World");

#endif

  kbdIn.begin();
  kbdOut.begin();
}


void loop()
{
#if 0

  if (Serial.available())
  {
    String str = Serial.readString();
    if (str) kbdIn.setDisplay(str.c_str());
  }

#endif

  static byte lastKey = 0;
  byte key = kbdIn.getKey();

  if (key && key != lastKey)
  {
    if (key == 1)
    {
      kbdOut.sendMediaKeyStroke(kHID_MediaVolumeMute);
    }
    else if (key == 2)
    {
      kbdOut.print("(- xyz äöüß ÄÖÜ []{}/\\?@~#+* -)");
    }
    else
    {
      byte m = kHID_ModLeftControl | kHID_ModLeftShift | kHID_ModLeftAlt;
      kbdOut.sendKeyPress(key + 3, m);
    }
  }
  
  if (!key && lastKey)
  {
    kbdOut.sendKeyPress(0, 0);
  }

  lastKey = key;

  kbdOut.delay(100);
}
