// 2020 Richard Kurz, no rights reserved.

#pragma once


struct TM1638
{
#if defined (__AVR_ATmega32U4__)

    static const byte dioPin = 4, clkPin = 3, stbPin = 2;

#elif defined (__AVR_ATtiny85__)

    static const byte dioPin = 2, clkPin = 1, stbPin = 0;

#elif defined (ESP32)

    static const byte dioPin = 18, clkPin = 19, stbPin = 23;

#endif

    void begin()
    {
      pinMode(clkPin, OUTPUT);
      pinMode(dioPin, OUTPUT);
      pinMode(stbPin, OUTPUT);

      digitalWrite(stbPin, HIGH);
      digitalWrite(clkPin, HIGH);

      resetDisplay(8);
      setDisplay("FACE . . . .");
    }


    byte getKey()
    {
      word keys = 0;
      byte k = 0;

      digitalWrite(stbPin, LOW);
      sendByte(0x42);
      for (byte i = 0; i < 4; ++i)
      {
        byte b = receiveByte();
        b = (((b & 0x40) >> 3 | (b & 0x04)) >> 2) | (b & 0x20) | (b & 0x02) << 3;
        keys |= ((b & 0x000F) << (i << 1)) | (((b & 0x00F0) << 4) << (i << 1));
      }
      digitalWrite(stbPin, HIGH);

      for (word n = keys; n; n >>= 1)
        ++k;

      return k;
    }


    void setDisplay(const char* str)
    {
      sendCommand(0x40);

      digitalWrite(stbPin, LOW);
      sendByte(0xc0);

      for (byte i = 0; i < 8; ++i)
      {
        byte led = 0;
        const char* s = str;

        for (byte j = 0; s[j]; ++j)
        {
          byte b = fontData(s[j]);
          led |= ((b >> i) & 1) << (7 - j);
          if (s[j + 1] == '.')
          {
            led |= (i == 7) << (7 - j);
            ++s;
          }
        }

        sendByte(led);
        sendByte(0);
      }

      digitalWrite(stbPin, HIGH);
    }


    void resetDisplay(byte brightness)
    {
      byte cmd = 0x80 | (brightness ? 8 : 0) | min(7u, (unsigned)brightness - 1);
      sendCommand(cmd);

      sendCommand(0x40);
      digitalWrite(stbPin, LOW);
      sendByte(0xc0);
      for (int i = 0; i < 16; i++)
        sendByte(0);
      digitalWrite(stbPin, HIGH);
      
      delayMicroseconds(2);
    }

  
  protected:

    void sendByte(byte data)
    {
      for (byte i = 0; i < 8; ++i)
      {
        digitalWrite(clkPin, LOW);
        delayMicroseconds(2);
        digitalWrite(dioPin, data & 1 ? HIGH : LOW);
        delayMicroseconds(2);
        digitalWrite(clkPin, HIGH);
        delayMicroseconds(2);
        data >>= 1;
      }
    }
    

    byte receiveByte()
    {
      byte b = 0;

      pinMode(dioPin, INPUT_PULLUP);
      digitalWrite(dioPin, HIGH);

      for (byte i = 0; i < 8; ++i)
      {
        digitalWrite(clkPin, LOW);
        delayMicroseconds(2);
        b |= digitalRead(dioPin) << i;
        digitalWrite(clkPin, HIGH);
        delayMicroseconds(2);
      }

      pinMode(dioPin, OUTPUT);
      digitalWrite(dioPin, LOW);

      return b;
    }
    

    void sendCommand(byte cmd)
    {
      digitalWrite(stbPin, LOW);
      sendByte(cmd);
      digitalWrite(stbPin, HIGH);
    }
    

    byte fontData(byte c)
    {
      static const byte nf[] PROGMEM =
      {
        0b00111111, // 0
        0b00000110, // 1
        0b01011011, // 2
        0b01001111, // 3
        0b01100110, // 4
        0b01101101, // 5
        0b01111101, // 6
        0b00000111, // 7
        0b01111111, // 8
        0b01101111, // 9
        0b01110111, // A
        0b01111100, // B
        0b00111001, // C
        0b01011110, // D
        0b01111001, // E
        0b01110001, // F
        0b01000000  // -
      };

      if (c >= '0' && c <= '9')       c -= '0';
      else if (c >= 'A' && c <= 'F')  c -= 'A' - 10;
      else if (c >= 'a' && c <= 'f')  c -= 'a' - 10;
      else if (c == '-')              c = 16;
      else                            return 0;

      return pgm_read_byte_near(nf + c);
    }
};

TM1638 kbdIn;
