#tag Class
Protected Class XExifTool
	#tag Method, Flags = &h0, Description = 537461727465742065696E6520616C6C67656D65696E6520457869662D546F6F6C2D41626672616765206465722044617465692E
		Sub CallExifTool(File As FolderItem)
		  Var sh As shell = CreateShell // Vorkonfigurierte Shell erzeugen lassen
		  If sh = Nil Then // Falls das nicht ging
		    RaiseEvent ExifError("Shell konnte nicht erzeugt werden", -1)
		    Return
		  End If
		  Var toolpath As FolderItem 
		  #If TargetMacOS
		    toolpath = SpecialFolder.Resources.Parent.child("Frameworks").child("bin").child("ExifTool") 
		  #ElseIf targetwindows
		    toolpath = SpecialFolder.Resources.child("exiftool.exe") 
		  #EndIf
		  
		  // Pfad zum Toolkit im Bundle der eigenen App lokalisieren
		  If toolpath = Nil Or Not toolpath.Exists Then // Für den Fall, dass dieses nicht da ist
		    RaiseEvent ExifError("ExifTool ist nicht da – bitte Programm neu installieren!", -2)
		    return
		  End If
		  Var Args() As String // Puffer für die Argumente der Shell
		  args.AddRow toolpath.ShellPath // erstes Argument: Der Pfad zum Toolkit
		  If Not LanguageCode.IsEmpty Then // Ausgabesprache definiert?
		    args.addrow "-lang"
		    args.addrow LanguageCode
		  End If
		  args.AddRow "-j" // Als JSON ausgeben
		  args.AddRow "-a" // Duplikate erlauben
		  args.AddRow "-G" // Ausgabe mit Gruppennamen versehen
		  args.AddRow "-g" // Ausgabe gruppieren
		  args.AddRow "-b" // Binärdaten extrahieren
		  
		  
		  args.AddRow file.ShellPath // und zum Schluss den Dateipfad übergeben
		  sh.Execute String.FromArray(args, " ")
		  ShellBuffer.Value(sh) = file
		  Catch Err // Eventuelle andere Fehler abfangen
		    RaiseEvent ExifError(err.message, err.errornumber)
		    
		End Sub
	#tag EndMethod

	#tag Method, Flags = &h21, Description = 45727A657567742065696E65206173796368726F6E65205368656C6C2C20646572656E204576656E7468616E646C657220616E20646965204B6C617373656E2D4576656E7448616E646C65726D6574686F64656E20616472657373696572742073696E642E
		Private Function CreateShell() As Shell
		  Var sh As New Shell // Legt eine neue Shell an
		  sh.ExecuteMode = shell.ExecuteModes.Asynchronous // Setzt ihren Modus auf asynchron
		  AddHandler sh.Completed, WeakAddressOf ShellCompletedHandler // Verbiegt den Event der Shell auf die Klassenmethoden
		  sh.TimeOut = -1 // Damit es unter Winows kein Timeout gibt
		  Return sh // Gibt die Shell zurück
		End Function
	#tag EndMethod

	#tag Method, Flags = &h21, Description = 4469657365204D6574686F64652077697264206175666765727566656E2C2077656E6E2064696545786966546F6F6C2D5368656C6C206265656E6465742077757264652C20756E64207665727A7765697420696E204665686C6572206F646572204572666F6C67732D48616E646C696E672E
		Private Sub ShellCompletedHandler(sh As Shell)
		  Var Exitcode As Integer = sh.ExitCode // Der Status der Shell. 0 = kein Fehler
		  If ExitCode = 0 Then
		    Var result As String = sh.ReadAll // Liest den Textbuffer der Shell
		    Try
		      Var js As New JSONItem(result)
		      RaiseEvent ExifCompleted(js) // und liefert ihn per Event aus
		    Catch err As JSONException
		      RaiseEvent ExifError("JSON Exception "+err.message, err.errornumber)
		    End Try
		  Else
		    RaiseEvent ExifError("Shell Fehler", ExitCode) // Da ist was schiefgegangen!
		  End If
		  ShellBuffer.Remove sh
		  
		End Sub
	#tag EndMethod


	#tag Hook, Flags = &h0, Description = 4665756572742C2077656E6E2065696E6520457869665368656C6C206572666F6C677265696368206265656E6465742077757264652E
		Event ExifCompleted(Result As JSonItem)
	#tag EndHook

	#tag Hook, Flags = &h0, Description = 46657565727420696D204665686C657266616C6C2E
		Event ExifError(Message As String, ErrorCode As Integer)
	#tag EndHook


	#tag Property, Flags = &h0, Description = 4F7074696F6E616C657220537072616368636F64652066C3BC72206469652057657274652E20466F726D6174207A2E422E20226465222066C3BC7220446575747363682E
		LanguageCode As String
	#tag EndProperty

	#tag Property, Flags = &h21
		Private mShellBuffer As Dictionary
	#tag EndProperty

	#tag ComputedProperty, Flags = &h21, Description = 496E7465726E65722053706569636865722C20756D20616B74697665205368656C6C732077C3A46872656E642064657220417262656974206C6562656E646967207A752068616C74656E2E
		#tag Getter
			Get
			  If mShellBuffer = Nil Then // Exisiert es noch nicht?
			    mShellBuffer = New Dictionary // neu anlegen
			  End If
			  Return mShellBuffer
			End Get
		#tag EndGetter
		Private ShellBuffer As Dictionary
	#tag EndComputedProperty


	#tag ViewBehavior
		#tag ViewProperty
			Name="Name"
			Visible=true
			Group="ID"
			InitialValue=""
			Type="String"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="Index"
			Visible=true
			Group="ID"
			InitialValue="-2147483648"
			Type="Integer"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="Super"
			Visible=true
			Group="ID"
			InitialValue=""
			Type="String"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="Left"
			Visible=true
			Group="Position"
			InitialValue="0"
			Type="Integer"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="Top"
			Visible=true
			Group="Position"
			InitialValue="0"
			Type="Integer"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="LanguageCode"
			Visible=true
			Group="Behavior"
			InitialValue="de"
			Type="String"
			EditorType="MultiLineEditor"
		#tag EndViewProperty
	#tag EndViewBehavior
End Class
#tag EndClass
