set fs = CreateObject("Scripting.FileSystemObject")
set dict = CreateObject("Scripting.Dictionary")
set tool = CreateObject("ct.update")

windir = fs.GetSpecialFolder(0).path

bildarchiv = "c:\bilder"

if not fs.FolderExists(bildarchiv) then
	' Ordner existiert nicht
	msgbox "Ordner " & bildarchiv & " existiert nicht!", vbExclamation
	WScript.quit
end if

set hintergrund = fs.GetFolder(bildarchiv).files

' alle Dateien darin untersuchen
cc=0

for each file in hintergrund
	' Dateityp ermitteln
	ext = lcase(fs.GetExtensionName(file.name))
	' ist es ein BMP-Bild?
	if ext = "bmp" then
		' ja, ins Dictionary einfgen
		
		dict.add cc, file.path
		cc=cc+1
	end if
next

if cc>0 then
	' eins der gesammelten Bilder aussuchen:
	Randomize
	zufall = Fix(rnd*dict.Count)

	' Bild aktivieren
	call tool.ChangeSetting(20, 0, dict(zufall))
else
	MsgBox "Keine BMP-Bilder im Ordner " & bildarchiv & "!"
end if