unit SingleCubeU; // 15-MAR-2000 as (Arne Schpers)
{ Einfacher, rotierender Wrfel im Immediate Mode
  Setzt DirectX 7, die Header-Dateien von Erik Unger
  und das von mir konvertierte SDK-Rahmenprogramm (D3DApp)
  voraus }


interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, Math,  // floor
  Direct3D, DirectDraw,  // Header von Erik Unger
  // D3D-Rahmenprogramm aus dem DX-SDK, auf Delphi umgesetzt
  D3DEnum,D3DApp,D3DFrame,D3DFile,D3DUtil;

type
  TSCForm = class(TD3DApplication)
    procedure FormCreate(Sender: TObject);
  private
    matCube: TD3DMatrix;
    m_pCubeFile: TD3DFile;
  protected  // Overrides fr TD3DApplication
    function OneTimeSceneInit: HResult; override;
    function InitDeviceObjects: HResult; override;
    function Render: HResult; override;
    function FrameMove(fTimeKey: FLOAT): HResult; override;
    function FinalCleanup: HResult; override;
  end;

var
  SCForm: TSCForm;

implementation

{$R *.DFM}

procedure TSCForm.FormCreate(Sender: TObject);
begin
  Caption := 'SingleCube (D3DIM)';
  m_bAppUseStereo   := TRUE;
  m_bAppUseZBuffer := TRUE;

  OnConfirmDevice := nil;  // alle D3D-Gerte abzhlen
  // D3D-Rahmen anlegen, ruft OneTimeSceneInit auf
  CreateFramework;
end;

// Wird einmal beim Programmstart aufgerufen, bernimmt alle
// von Grafiktreiber und -modus unabhngigen Initialisierungen
function TSCForm.OneTimeSceneInit: HResult;
begin
  m_pCubeFile := TD3DFile.Create;
  Result := m_pCubeFile.Load('cube.x');
  if FAILED(Result) then
     ShowMessage('Error loading CUBE.X file');
end;

// Gegenstck zu OneTimeSceneInit
function TSCForm.FinalCleanup: HResult;
begin
  m_pCubeFile.Free;
  Result := S_OK;
end;

// Von Grafiktreiber und -modus abhngige Initialisierungen,
// wird bei jedem Wechsel erneut aufgerufen
function TSCForm.InitDeviceObjects: HResult;
var matWorld, matProj: TD3DMatrix;
    vEyePt, vLookatPt, vUpVec: TD3DVector;
    Light: TD3DLight7;
begin
  // camera position
  vEyePt    := D3DVECTOR(0.0, 0.0, -4.5);
  vLookatPt := D3DVECTOR(-0.4, 0.0,  0.0);  // sligthly off center
  vUpVec    := D3DVECTOR(0.0, 1.0,  0.0);
  // set camera position
  SetViewParams(@vEyePt, @vLookatPt, @vUpVec, 0.1);

  D3DUtil_SetIdentityMatrix(matWorld );
  D3DUtil_SetProjectionMatrix(matProj, Pi/4, 1.0, 1.0, 10.0);

  with m_pd3dDevice do
  begin
    SetTransform(D3DTRANSFORMSTATE_WORLD, matWorld );
    SetTransform(D3DTRANSFORMSTATE_PROJECTION, matProj);
  end;

  // lighting
  with m_pd3dDevice do
  begin
    SetRenderState(D3DRENDERSTATE_LIGHTING, Ord(True) );

    // Directional: Position wird ignoriert, Light scheint
    // direkt in den Bildschirm hinein
    D3DUtil_InitLight(Light, D3DLIGHT_DIRECTIONAL, 0, 0, 10);
    with Light do
    begin
      dcvDiffuse.R := 1.0; dcvDiffuse.G := 0; dcvDiffuse.b := 0;
      dcvAmbient := dcvDiffuse; dcvAmbient.R := 0.2;
    end;

    SetLight(0, Light );
    LightEnable(0, True);
  end;

  Result := S_OK;
end;

// Fortschreibung der Bewegung abhngig von fTimeKey
function TSCForm.FrameMove(fTimeKey: FLOAT): HResult;
begin
  // Drehmatrix fr den Wrfel
  D3DUtil_SetRotationMatrix(matCube, D3DVECTOR(1.0,1.0,0.5), fTimeKey/2);
  Result := S_OK;
end;


// Wird einmal pro Frame aufgerufen (Transformationsmatrizen,
// Objekte, Viewports etc. bereits eingerichtet). Lscht den
// Viewport und zeichnet die gesamte Szene
function TSCForm.Render: HResult;
begin
  // Clear the viewport
  m_pd3dDevice.Clear(0, nil, D3DCLEAR_TARGET or D3DCLEAR_ZBUFFER,
                     $000000ff, 1.0, 0);

  // Begin the scene
  with m_pd3dDevice do
    if SUCCEEDED(BeginScene) then
    begin
      SetTransform(D3DTRANSFORMSTATE_WORLD, matCube);
      m_pCubeFile.Render(m_pd3dDevice);
      EndScene;
  end;
  Result := S_OK;
end;

end.

