#include <jni.h>
#include <stdio.h>
#include <math.h>
#include "classtwo.h"

JNIEXPORT jdouble JNICALL Java_classtwo_jnipower(JNIEnv *env, 
                                                 jclass in_cls, 
                                                 jint in_int, 
                                                 jstring in_string,
                                                 jfloat in_float) 
  {
  /* Java String in C-String konvertieren und an C-Variable 
     zuweisen: */
  const char *c_string = (*env)->GetStringUTFChars(env, in_string, 0);

  /* Adresse des Feldes "ddd" in der der aufrufenden Klasse 
     ermitteln: */
  jfieldID jfid = (*env)->GetStaticFieldID(env, in_cls, "ddd", "D");
  /* Wert des Feldes "ddd" aus der aufrufenden Klasse auslesen: */
  double in_double = (*env)->GetStaticDoubleField(env, in_cls, jfid);

  printf("%s %lf + pow(%d,%f)\n", 
         c_string, in_double, in_int, in_float);

  return (in_double + pow(in_int,in_float));
  }

