#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#


package M_messages;




#---------------------------------------------------------------
#
#   texts for html-interface
#
#---------------------------------------------------------------
#-  language: 0  - english
#-            1  - deutsch
#-
#-        messages[language][messNo]

my @messages = (
	       
	       #-------- english
	       {
		  ErrUnknown              => "unknown error",
		
	       },
	       
	       #-------- deutsch
	       {
		  ErrUnknown              => "unbekannter Fehler",
		
	       },

	      );
	      

#---------------------------------------------------------------

sub getMessage {
  my ($language,$messNo) = @_;

  return( $messages[$language]{$messNo} );
}

#---------------------------------------------------------------
#---------------------------------------------------------------




#---------------------------------------------------------------
#
#    texts for fontsizes in wml-interface
#
#---------------------------------------------------------------
# ein hash aus hashes
my %fonts = (
		
	    EN => {                      # englisch
		   S    => "small",
		   N    => "normal",
		  },
	    
	    DE => {                      # deutsch
		   S    => "klein",
		   N    => "normal",
		  },
	    
	    ES => {                      # spanisch
		   S    => "pico",
		   N    => "normal",
		  },
	    
	   );


#----------------------------
# returns string containing language identifiers
sub getLanguages {
  my $lang = "";
  foreach $l (keys %fonts) {
    $lang = $l . " ". $lang;
  }
  chop($lang);
  return ($lang);
}

#----------------------------
# returns string containing fonts identifiers
sub getFonts {
  my $afonts = "";
  foreach $l (keys %{$fonts{'EN'}}) {
    $afonts = $l . " ". $afonts;
  }
  chop($afonts);
  return ($afonts);
}

#----------------------------
# returns referenz to hash containing names of sizes
sub getSizesHashRef { 
  my ($lcode) = @_;
  return($fonts{$lcode});
}

#---------------------------------------------------------------

1;

#---------------------------------------------------------------




