#!/usr/bin/perl -w
#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#

use CGI;
use CGI::Carp qw/fatalsToBrowser/;
use CGI qw/:standard :html3/;
use Unix::Syslog qw(:macros);
use Unix::Syslog qw(:subs);


require "../shared_modules/M_user.pm";
require "../shared_modules/M_session.pm";
require "M_tools.pm";
require "html_interface.cfg";


#--- 
my $debug = 0;          # debug-messages
my $logit = 1;          # sysloggen
$M_session::debug = $debug;


#---------------------
$logoff_message     = $html_interface_config::mess_logoff;
$mail_message       = $html_interface_config::mess_mail;     

#--- for User-DB
my $UserDB_DIR      = "../databases/ZWap-User";
my $UserDB_DSN      = "DBI:CSV:f_dir=$UserDB_DIR";
my $UserDB_USER     = "";
my $UserDB_PASSWD   = "";

#--- for SessionDB
my $SessDB_DIR      = "../databases/ZWap-SessionKeys";
my $SessDB_DSN      = "DBI:CSV:f_dir=$SessDB_DIR";
my $SessDB_USER     = "";
my $SessDB_PASSWD   = "";

#-------------- let's start  --------------------
my $query = new CGI;

my $ID = $query->param("id");
my $P  = $query->param("p");


#--- establish syslog-connection 
openlog("zWAP-html: Z_cancel.pl", LOG_PID, LOG_DAEMON) if $logit;

#-- start HTML 
print $query->header();
print start_html(-BGCOLOR=>'#FFFFFF');


if ( $ID ne "") {

  my $RET = 0;
  my $UserDbh = M_user::connectDB( 
				  $UserDB_DSN,
				  $UserDB_USER,
				  $UserDB_PASSWD
				 );

  if ( $UserDbh ) {
    $RET = M_user::auth( $UserDbh, $ID, $P);
    M_user::disconnectDB( $UserDbh );
  } else {
    print "<br>cannot connect to user-DB<br>\n";
    $RET = 99;
  }

  if ( $RET == 1) {
    my $SessionDbh = M_session::connectDB( 
					  $SessDB_DSN,
					  $SessDB_USER,
					  $SessDB_PASSWD
					 );
    if( $SessionDbh) { 
      if ( M_session::userIn( $SessionDbh, $ID) ) {
	$sessID = M_session::getSessionFromID($SessionDbh, $ID);
	
	M_session::deleteSessID( $SessionDbh, $sessID);
	do_cancelled( $sessID, $ID);

	# syslog:
	syslog( LOG_INFO, "member $ID cancelled session $sessID.") if $logit;
      } else {
	do_noactiv( $ID);
	# syslog:
	syslog( LOG_INFO, "no active session for member $ID .") if $logit;
      }

      M_session::disconnectDB( $SessionDbh);
    } else {
      print "<br>cannot connect to session-DB<br>\n";
    }

  } elsif ( $RET == 2) {
    do_nouser($ID);
    # syslog:
    syslog( LOG_INFO, "member $ID does not exist.") if $logit;
  } else {
    do_nopw($ID);
    # syslog:
    syslog( LOG_INFO, "wrong password for member $ID.") if $logit;
  }
  
} else {
  do_noentry();
}

#-- end HTML 
print $query->end_html();

#--- close syslog-connection
closelog() if $logit;


#--------------------- subs ---------------------------

#--- there was no ID entered ------------------
sub do_noentry {
  print $query->h1("Sorry, you entered no ID or password.");
}


#--- session cancelled   ------------------
sub do_cancelled {
  my ($sessID,$ID) = @_;

  print $query->h1("Session $sessID for User $ID cancelled.");

  M_tools::print_file($logoff_message);
  M_tools::print_file($mail_message);
}


#--- login failed ------------------
sub do_loginFailed {
  my ($ID) = @_;
  print $query->h1("Unknown error occured during login of $ID.");
}

#--- session for user is not active --------------------------
sub do_noactiv {
  my ($ID) = @_;
  print $query->h1("For user $ID there is no active session.");
}

#--- user not found  ------------------------------
sub do_nouser {
  my ($ID) = @_;
  print $query->h1("User $ID doesn't exists.");
}

#--- false password  ----------------------------------
sub do_nopw {
  my ($ID) = @_;
  print $query->h1("The password for user $ID is not correct.");
}


#--------------------- end subs -----------------------


