#include "StdAfx.h"
#include "SAPATLToolkit.h"

CDispPtr::CDispPtr()
{
}

CDispPtr::CDispPtr(IDispatch* lp):
   CComDispatchDriver(lp)
{
}

CDispPtr::CDispPtr(IUnknown* lp):
   CComDispatchDriver(lp)
{
}

CDispPtr::CDispPtr(const CDispPtr &lp):
   CComDispatchDriver(lp.p)
{
}

IDispatch* CDispPtr::operator=(IDispatch* lp)
{
	return this->CComDispatchDriver::operator=(lp);
}

IDispatch* CDispPtr::operator=(IUnknown* lp)
{
	return this->CComDispatchDriver::operator=(lp);
}

CDispPtr& CDispPtr::operator=(CDispPtr& lp)
{
	this->CComDispatchDriver::operator=(lp.p);
	return *this;
}

HRESULT CDispPtr::GetIdOfName(OLECHAR* pName,LCID lcid,DISPID& rDispId)
{
	_ASSERTE(p);

	HRESULT		hr = E_FAIL;
	
	try {
		if ( p != NULL ) {
			hr = p->GetIDsOfNames(IID_NULL,&pName,1,lcid,&rDispId);
		}else{
			hr = E_FAIL;
		};
	} catch(...) {
		hr = E_FAIL;
	};

	return hr;
}

HRESULT CDispPtr::GetPropertyByID(DISPID nDispID,LCID lcid, VARIANT* pVar)
{
	_ASSERTE(p);

	HRESULT		hr = E_FAIL;

	try {
		VariantClear(pVar);

		if ( p != NULL ) {
			return GetProperty(p, nDispID, pVar);
		}else{
			hr = E_FAIL;
		};
	} catch(...) {
		hr = E_FAIL;
	};

	return hr;
}

HRESULT CDispPtr::PutPropertyByID(DISPID nDispID,LCID lcid, VARIANT* pVar)
{
	_ASSERTE(p);

	HRESULT		hr = E_FAIL;

	try {
		if ( p != NULL ) {
			hr = PutProperty(p, nDispID, pVar);
		}else{
			hr = E_FAIL;
		};
	} catch(...) {
		hr = E_FAIL;
	};

	return hr;
}

HRESULT CDispPtr::InvokeMethodByID(DISPID nDispID,LCID lcid,DISPPARAMS* pDispParams,VARIANT* pVarResult,UINT* pArgErr)
{
	_ASSERTE(p);

	HRESULT		hr = E_FAIL;
	DISPPARAMS  dispNoArgs = {NULL, NULL, 0, 0};
	DISPPARAMS* pArgs;
	UINT		nArgError = 0;
	UINT*       pArgError = NULL;

	try {
		if ( p != NULL ) {
			if ( pDispParams != NULL ) {
				pArgs = pDispParams;
			}else{
				pArgs = &dispNoArgs;
			};
			if ( pArgErr != NULL ) {
				pArgError = pArgErr;
			}else{
				pArgError = &nArgError;
			};
			hr = p->Invoke(nDispID,IID_NULL,lcid,DISPATCH_METHOD,pArgs,pVarResult,NULL,pArgError);
		}else{
			hr = E_FAIL;
		};
	} catch(...) {
		hr = E_FAIL;
	};

	return hr;
}

HRESULT CDispPtr::GetIndexedPropertyByID(DISPID nDispID,LCID lcid,DISPPARAMS* pDispParams,VARIANT* pVarResult,UINT* pArgErr)
{
	_ASSERTE(p);

	HRESULT		hr = E_FAIL;
	DISPPARAMS  dispNoArgs = {NULL, NULL, 0, 0};
	DISPPARAMS* pArgs;
	UINT		nArgError = 0;
	UINT*       pArgError = NULL;

	try {
		if ( p != NULL ) {
			if ( pDispParams != NULL ) {
				pArgs = pDispParams;
			}else{
				pArgs = &dispNoArgs;
			};
			if ( pArgErr != NULL ) {
				pArgError = pArgErr;
			}else{
				pArgError = &nArgError;
			};
			hr = p->Invoke(nDispID,IID_NULL,lcid,DISPATCH_PROPERTYGET,pArgs,pVarResult,NULL,pArgError);
		}else{
			hr = E_FAIL;
		};
	} catch(...) {
		hr = E_FAIL;
	};

	return hr;
}

HRESULT CDispPtr::GetDispPropertyByID(DISPID nDispID, LCID lcid, CDispPtr& rObj)
{
	HRESULT hr;

	CComVariant aVar;

	try {
		rObj.Release();
	} catch (...) {
	};

	hr = this->GetPropertyByID(nDispID,lcid,&aVar);

	if ( aVar.vt == VT_DISPATCH && aVar.pdispVal != NULL ) {
		try {
			rObj = aVar.pdispVal;
		} catch (...) {
			hr = E_FAIL;
		};
	}else{
		hr = E_NOINTERFACE;
	};

	return hr;
}

HRESULT CDispPtr::GetPropertyByName(OLECHAR* pName, LCID lcid, VARIANT* pVar)
{
	_ASSERTE(p);

	HRESULT		hr = E_FAIL;
	DISPID		theDispID = 0;

	try {
		VariantClear(pVar);

		if ( p != NULL ) {
			hr = p->GetIDsOfNames(IID_NULL,&pName,1,lcid,&theDispID);
			if ( SUCCEEDED(hr) ) {
				hr = GetProperty(p, theDispID, pVar);
			};
		}else{
			hr = E_FAIL;
		};
	} catch(...) {
		hr = E_FAIL;
	};

	return hr;
}

HRESULT CDispPtr::PutPropertyByName(OLECHAR* pName, LCID lcid, VARIANT* pVar)
{
	_ASSERTE(p);

	HRESULT		hr = E_FAIL;
	DISPID		theDispID = 0;

	try {
		if ( p != NULL ) {
			hr = p->GetIDsOfNames(IID_NULL,&pName,1,lcid,&theDispID);
			if ( SUCCEEDED(hr) ) {
				hr = PutProperty(p, theDispID, pVar);
			};
		}else{
			hr = E_FAIL;
		};
	} catch(...) {
		hr = E_FAIL;
	};

	return hr;
}

HRESULT CDispPtr::InvokeMethodByName(OLECHAR* pName,LCID lcid,DISPPARAMS* pDispParams,VARIANT* pVarResult,UINT* pArgErr)
{
	_ASSERTE(p);

	HRESULT		hr = E_FAIL;
	DISPID		theDispID = 0;
	DISPPARAMS  dispNoArgs = {NULL, NULL, 0, 0};
	DISPPARAMS* pArgs;
	UINT		nArgError = 0;
	UINT*       pArgError = NULL;

	try {
		if ( p != NULL ) {
			hr = p->GetIDsOfNames(IID_NULL,&pName,1,lcid,&theDispID);
			if ( SUCCEEDED(hr) ) {
				if ( pDispParams != NULL ) {
					pArgs = pDispParams;
				}else{
					pArgs = &dispNoArgs;
				};
				if ( pArgErr != NULL ) {
					pArgError = pArgErr;
				}else{
					pArgError = &nArgError;
				};
				hr = p->Invoke(theDispID,IID_NULL,lcid,DISPATCH_METHOD,pArgs,pVarResult,NULL,pArgError);
			};
		}else{
			hr = E_FAIL;
		};
	} catch(...) {
		hr = E_FAIL;
	};

	return hr;
}

HRESULT CDispPtr::InvokeMethodByName(OLECHAR* pName,LCID lcid,DISPPARAMS* pDispParams,VARIANT* pVarResult,UINT* pArgErr,UINT* pError,CComBSTR& rErrorString)
{
	_ASSERTE(p);

	HRESULT		hr = E_FAIL;
	DISPID		theDispID = 0;
	DISPPARAMS  dispNoArgs = {NULL, NULL, 0, 0};
	DISPPARAMS* pArgs;
	UINT		nArgError = 0;
	UINT*       pArgError = NULL;
	EXCEPINFO	theInfo;

	memset(&theInfo,0,sizeof(theInfo));

	try {
		if ( p != NULL ) {
			hr = p->GetIDsOfNames(IID_NULL,&pName,1,lcid,&theDispID);
			if ( SUCCEEDED(hr) ) {
				if ( pDispParams != NULL ) {
					pArgs = pDispParams;
				}else{
					pArgs = &dispNoArgs;
				};
				if ( pArgErr != NULL ) {
					pArgError = pArgErr;
				}else{
					pArgError = &nArgError;
				};
				hr = p->Invoke(theDispID,IID_NULL,lcid,DISPATCH_METHOD,pArgs,pVarResult,&theInfo,pArgError);

				if ( hr == DISP_E_EXCEPTION ) {
					if ( pError ) {
						if ( theInfo.wCode != 0 ) {
							*pError = theInfo.wCode;
						}else{
							*pError = theInfo.scode;
						};
					};

					if ( theInfo.pfnDeferredFillIn ) {
						HRESULT lhr = theInfo.pfnDeferredFillIn(&theInfo);				
					};

					rErrorString = theInfo.bstrDescription;

					if ( theInfo.bstrSource ) ::SysFreeString(theInfo.bstrSource);
					if ( theInfo.bstrDescription ) ::SysFreeString(theInfo.bstrDescription);
					if ( theInfo.bstrHelpFile ) ::SysFreeString(theInfo.bstrHelpFile);
				};
			};
		}else{
			hr = E_FAIL;
		};
	} catch(...) {
		hr = E_FAIL;
	};

	return hr;
}

HRESULT CDispPtr::GetIndexedPropertyByName(OLECHAR* pName,LCID lcid,DISPPARAMS* pDispParams,VARIANT* pVarResult,UINT* pArgErr)
{
	_ASSERTE(p);

	HRESULT		hr = E_FAIL;
	DISPID		theDispID = 0;
	DISPPARAMS  dispNoArgs = {NULL, NULL, 0, 0};
	DISPPARAMS* pArgs;
	UINT		nArgError = 0;
	UINT*       pArgError = NULL;

	try {
		if ( p != NULL ) {
			hr = p->GetIDsOfNames(IID_NULL,&pName,1,lcid,&theDispID);
			if ( SUCCEEDED(hr) ) {
				if ( pDispParams != NULL ) {
					pArgs = pDispParams;
				}else{
					pArgs = &dispNoArgs;
				};
				if ( pArgErr != NULL ) {
					pArgError = pArgErr;
				}else{
					pArgError = &nArgError;
				};
				hr = p->Invoke(theDispID,IID_NULL,lcid,DISPATCH_PROPERTYGET,pArgs,pVarResult,NULL,pArgError);
			};
		}else{
			hr = E_FAIL;
		};
	} catch(...) {
		hr = E_FAIL;
	};

	return hr;
}

HRESULT CDispPtr::GetDispPropertyByName(OLECHAR* pName, LCID lcid, CDispPtr& rObj)
{
	HRESULT hr;

	CComVariant aVar;

	try {
		rObj.Release();
	} catch (...) {
	};

	hr = this->GetPropertyByName(pName,lcid,&aVar);

	if ( SUCCEEDED(hr) ) {
		if ( aVar.vt == VT_DISPATCH && aVar.pdispVal != NULL ) {
			try {
				rObj = aVar.pdispVal;
			} catch (...) {
				hr = E_FAIL;
			};
		}else{
			hr = E_NOINTERFACE;
		};
	};

	return hr;
}
