Option Explicit

Const sApplicationTitle = """Mein schnstes Buch"""
Const sConfigFileName = "00BuchProjektKonfiguration.txt"

Sub CompileDocuments
'Autor Werner Roth <werner@wernerroth.de>
'Dieses Makro sucht einen Verzeichnisbaum auf der Festplatte nach
'StarOffice Writer Dokumenten ab und kopiert sie aneinander.
'Die Reihenfolge ergibt sich aus der Sortierung der Dateinamen
'(inkl. Pfad).
'Die maximale Gliederungsebene der Dokumente wird anhand der 
'Verzeichnishierarchie angepasst

Dim oMainDocument As Object 'Zeiger auf das Gesamtdokument
'Liste aller Verzeichniss, die durchsucht werden sollen
Dim sDirs As New Strings
'Liste aller Dateien, die Zusammengestellt werden
Dim sFiles As New Strings
Dim sFile As String 'Merker eines aktuellen Dateinamens
Dim i As Integer 'For-Schleifen Bttel
'Zum Herausfinden der maximalen Gliederungsstufe
Dim iInitialDirLevel As Integer, iMaxOutlineLevel As Integer

'Rahmeninformation fr dieses Programm ist:
'Datenverzeichnis - Wurzel des Baums in dem alle Teildokumente stehen
'Dokumentvorlage - Vorlage fr das generierte Dokument
'Gesamtdokumentname - Dateiname inkl. Pfad des generierten Dokuments
Dim sDocumentFilesDir As String, sMainDocumentTemplate As String
Dim sMainDocumentFile As String

'Hole dir obige Rahmeninformation. Damit man die nicht andauernd
'eingeben muss, wird sie in eine Initialisierungsdatei in das
'Arbeitsverzeichnis des Nutzers geschrieben.
'Eine schnere Lsung mag ein StarOffice Basic Dialog sein. Das ist
'einfach zu ndern.
GetConfigData(sDocumentFilesDir, sMainDocumentTemplate, _
              sMainDocumentFile)


'Erstmal den Verzeichnisbaum in eine Stringliste generieren
'StarOffice Basic kann keine rekursiven Prozeduraufrufe,
'deshalb folgende Vorgehensweise:

'Mit einem Verzeichnis anfangen, dazu alle Unterverzeichnisse
'anhngen, mit dem ersten Unterverzeichnis weitermachen und dessen
'Unterverzeichnisse anhngen. Solange bis das Listenende da ist...
i = 1
sDirs.Add(sDocumentFilesDir)
Do While i <= sDirs.Count
   AddSubDirs(sDirs, sDirs.Item(i))
   i = i + 1
Loop

'Nun die Liste der Verzeichnisse nach StarOffice Writer Dateien
'durchschauen und zu einer Liste "sFiles" zusammenstellen
'Wer hier nach .HTML, .DOC, .TXT oder andere Dokumantformate
'aufnehmen mag: Nur zu!

'Zur Erluterung der iMaxOutlineLevel-Dinge:
'Fr jedes Dokument wird die maximale Gliederungsebene anhand der
'Verzeichnisstruktur ausgerechnet.
'Im Wurzelverzeichnis z.B. "c:\text" ist iMaxOutlineLevel = 0
'Im ersten Unterinhaltsverzeichnis z.B. "c:\text\01_kapitel" ist
'iMaxOutlineLevel = 1

'Findet sich in "c:\text\02_kapitel\04_ukapitel\01_abschnitt"
'(iMaxOutlineLevel = 3) ein Dokument, das Gliederungen mit
'"berschrift 1" enthlt, so werden in diesem Dokument alle
'berschriften um zwei Ebenen verschoben. Aus "berschrift 1" wird
'"berschrift 3", aus "berschrift 2" wird "berschrift 4", usw.

'Gliederungsebenen werden nur erhht, niemals erniedrigt!
'Somit ist es nicht ntig, fr jede Gliederungsebene ein
'Unterverzeichnis anzulegen!

'Berechne die Gliederungsebene anhand von "\" im Windows-Pfadnamen
'bzw. "/" unter Unix
iInitialDirLevel = StringHowManyTimesIn(sDocumentFilesDir, _
                                        GetPathSeparator())

For i = 1 To sDirs.Count
   'iMaxOutlineLevel berechnet sich aus der Pfadlnge
   iMaxOutlineLevel = StringHowManyTimesIn(sDirs.Item(i), _
                         GetPathSeparator()) - iInitialDirLevel
   'Sammle aus jedem Verzueichnis die Dateien ein
   sFile = Dir(sDirs.Item(i) & GetPathSeparator() & "*.sdw")
   Do While sFile <> ""
      sFiles.Add(sDirs.Item(i) & GetPathSeparator() & sFile)
      
      'Korrigiere ggf. die maximale Gliederungsebene
      '(und speichere das Dokument)
      CorrectOutlineLevel(sDirs.Item(i) & GetPathSeparator() & _
                          sFile, iMaxOutlineLevel)

      sFile = Dir()
   Loop
Next i 'Alle gefundenen Verzeichnisse

Erase sDirs 'brauchen wir nicht mehr

'Sortiere die Dateien nach Pfad- und Dateinamen
'Beispiel:
'c:\text\01_kapitel\00_Intro.sdw
'c:\text\02_kapitel\01_Maden.sdw
'c:\text\02_kapitel\02_Schmetterlinge.sdw
'c:\text\anhaenge.sdw
SortStringList(sFiles)
'TempPrintStringList(sFiles)

'Nun basteln wir das Ganze mal in ein Dokument!
'Zuerst per Dokumentvorlage ein neues Gesamtdokument erzeugen
oMainDocument = Documents.Open(sMainDocumentTemplate,,"T")
'Wer ohne Dokumentvorlage arbeiten will, nehme
'Documents.Add("swriter")
oMainDocument.Activate()
'Bildschirmausgabe bei Manipulationen an diesem Dokument unterdrcken
ActiveWindow.ActionStart()
'Nachzulesen unter Datei|Eigenschaften Register Beschreibung
oMainDocument.Documentinfo.Description = "Generiert am: " & _
                                         Date & " - " & Time

'Nun mssen alle Dateien in das Gesamtdokument eingefgt werden.
'Das wrde im Prinzip einfach mit 
'Selection.InsertFile(sFiles.Item(i)) funktionieren.
'Am Ende des Dokuments muss ein leerer Absatz eingefgt werden,
'in den das Dokument eingefgt wird. Der zustzliche Aufwand liegt
'daran, dass exakt zu Beginn des Dokuments eine Textmarke und eine
'Notiz eingefgt werden sollen, die ber das Dokument Auskunft
'erteilen.
For i = 1 To sFiles.Count
   With Selection
      .JumpToEndOfDoc() 'Ganz ans Ende des Dokuments gehen
      'Zwei leere Abstze einfgen (den zweiten Lschen wir wieder)
      .InsertPara()      
      .StyleApply( "Standard", 2 )
      .InsertPara()
      .GoLeft(1)
      'Merken wo wir stehen
      .InsertBookmark("TemporaryBookmarkInsertingFile")
      'Dokumentname als Textmarke einfgen
      .InsertBookmark("InsertedFile " & sFiles.Item(i))
      'Nun haben wir einen Absatz platz, so dass die Textmarke nicht
      'hinter das Dokumentende verschoben wird.
      .GotoEndOfDoc()
      .InsertFile(sFiles.Item(i))
      'Zrck zum Dokumentbeginn 
      .JumpToBookmark("TemporaryBookmarkInsertingFile")
      '.DeleteBookmark("TemporaryBookmarkInsertingFile")
      'wird ohnehin gleich gelscht
      'Eine Notiz mit den Dokumenteigenschaften einfgen:
      .InsertAnnotation(GetDocInfos(sFiles.Item(i)))
      'und den leeren Absatz wegnehmen
      .GoRight(1)
      .Backspace()
   End With
Next i 'Alle Dokumente aus der Stringlist "sFiles"
   
oMainDocument.Activate()
'Bildschirmaktionen des Gesamtdokuments wieder einschalten
ActiveWindow.ActionEnd()
'und das Ding speichern.
'oMainDocument.Close(True, sMainDocumentFile) Schlieen mit speichern
oMainDocument.SaveAs(sMainDocumentFile) ' nur speichern

Erase sFiles

End sub

'***** ENDE Hauptprogramm *****


Sub GetConfigData(sDocumentFilesDir As String, _
   sMainDocumentTemplate As String, sMainDocumentFile As String)
'Holt die Rahmeninformationen:
'Datenverzeichnis - Wurzel des Baums, in dem alle Teildokumente stehen
'Dokumentvorlage - Vorlage fr das generierte Dokument
'Gesamtdokumentname - Dateiname inkl. Pfad des generierten Dokuments
'aus der Datei:
'<StarOffice Arbeitsverzeichnis> + <Konstante sConfigFileName>
'z.B.: "c:\Eigene Dateien\00BuchProjektKonfiguration.txt"

   'Konfigurationsdateiname inkl. Pfad
   Dim sConfigFilePath As String
   'Filehandler der Konfigurationsdatei
   Dim iFileNumber As Integer
   'Sollen/mssen die Rahmeninformationen abgefragt werden?
   Dim bNewData As Boolean
   
   sDocumentFilesDir = ""
   sMainDocumentTemplate = ""
   sMainDocumentFile = ""

   sConfigFilePath = Application.PathSettings.Work & _
                     GetPathSeparator() & sConfigFileName
   
   bNewData = True

   'Gibt es die Konfigurationsdatei?
   If Dir(sConfigFilePath) <> "" Then
      'Falls ja, lies die Konfiguration aus
      iFileNumber = FreeFile()
      Open sConfigFilePath for Input As #iFileNumber
      Line Input #iFileNumber, sDocumentFilesDir
      Line Input #iFileNumber, sMainDocumentTemplate
      Line Input #iFileNumber, sMainDocumentFile
      Close #iFileNumber

      'und frag ob das so in Ordnung geht!
      bNewData = (MsgBox("Wollen sie Datenverzeichnis: '" & _
         sDocumentFilesDir & "'," & chr(13) & _
         "Dokumentvorlage: '" & sMainDocumentTemplate & "'," & _
         chr(13) & "und Gesamtdokumentdatei: '" & _
         sMainDocumentFile & "'" & chr(13) & "neu eingeben?", _
         4 ,sApplicationTitle) = 6)
   End If

   If bNewData Then
      'Entweder gab es noch keine Konfiguration oder die
      'Rahmeninformationen sollen erneut abgefragt werden

      MsgBox("Geben Sie nun bitte nach einander " & _
         "Datenverzeichnis, Dokumentvorlage " & chr(13) & _
         "und Gesamtdokumentname an." & chr(13) & _
         "Die Einstellungen werden unter:" & chr(13) & _
         sConfigFilePath & chr(13) & "gespeichert!", _
         0,sApplicationTitle)

      'Frage die einzelnen Posten ab. Falls noch nicht da, werden sie
      'mit den Deafultwerten gefllt.
      'Wenn der Rckgabewert leer "" ist, dann wurde der Dialog
      'abgebrochen!

      If sDocumentFilesDir = "" Then sDocumentFilesDir = _
                                        Application.PathSettings.Work
      sDocumentFilesDir = Application.FileDialog( "P", _
         "Wurzelverzeichnis von " & sApplicationTitle, _
         sDocumentFilesDir )
      If sDocumentFilesDir = "" Then
         Exit Sub
      End If
   
      If sMainDocumentTemplate = "" Then
         'Die StarOffice-Dokumentvorlagen knnen in mehreren 
         'Verzeichnissen getrennt von Semikolons getrennt werden.
         'Das Hinterste ist meist das benutzereigene Verzeichnis.
         sMainDocumentTemplate = Application.PathSettings.Template
         Do While InStr(sMainDocumentTemplate,";") > 0
            sMainDocumentTemplate = Mid(sMainDocumentTemplate, _
               InStr(sMainDocumentTemplate,";") + 1)
         Loop
      End If
      sMainDocumentTemplate = Application.FileDialog( "O", _
         "Dokumentvorlage von " & sApplicationTitle, _
         sMainDocumentTemplate)
      If sMainDocumentTemplate = "" Then
         Exit Sub
      End If
   
      If sMainDocumentFile = "" Then sMainDocumentFile = _
         Application.PathSettings.Work & GetPathSeparator() & _
         "Buch.sdw"
      sMainDocumentFile = Application.FileDialog( "S", _
         "Gesamtdokument von " & sApplicationTitle, sMainDocumentFile)
      If sMainDocumentTemplate = "" Then
         Exit Sub
      End If
   End If

   'Getroffene Einstellungen in die Konfigurationsdatei
   'zurckschreiben

   iFileNumber = FreeFile()
   Open sConfigFilePath for Output As #iFileNumber
   Print #iFileNumber, sDocumentFilesDir
   Print #iFileNumber, sMainDocumentTemplate
   Print #iFileNumber, sMainDocumentFile
   Print #iFileNumber, ";Initialisierungsdaten " & _
                       sApplicationTitle & " bitte nicht editieren"
   Close #iFileNumber

End Sub 'GetConfigData

'*****

Sub AddSubDirs(ByVal sDirs As Strings, ByVal sPath As String)
'Hngt an die Stringliste "sDirs" alle Unterverzeichnisse von
'"sPath" an

   Dim sThisDir as String

   '16 listet nach und nach alle Verzeichnisse auf
   sThisDir = Dir(sPath,16)
   Do 
      If sThisDir <> "." and sThisDir <> ".." Then 
         'Wenn ein echtes Verzeichnis gefunden wurde,
         'an die Liste anhngen.
         sDirs.Add(sPath & GetPathSeparator() & sThisDir) 
      End If 
      sThisDir = Dir() 'hole den nchsten Verzeichnissnamen
      'wenn keiner mehr da ist liefert Dir() einen leeren
      'String zurck
   Loop Until sThisDir = "" 
End Sub 'AddSubDirs

'*****

Sub SortStringList(ByVal sValue As Strings)
'Sortiert eine gegebene Stinglist
'"sValue" zeigt auf die bergebene Objektinstanz
'Leider bieten StarOffice Basic Stinglisten weder eine Methode
'.Sort() noch so etwas wie .Move(i,j)
'Es stehen nur .Add(Value) und .Remove(Index) zur Verfgung
'deshalb beim Sortieren foldgende Strategie:
'- kleinstes Element der obersten n Elemente suchen
'- Aus der Liste lschen
'- und unten an die Liste anhngen
'- Das Ganze mit den n-1 ersten Elementen wiederholen.

Dim i As Integer
'Zur Suche des kleinsten Elements
Dim iAktMin As Integer
'Wie viele Elemente sind noch nicht umgehangen?
Dim iUnsortEnd As Integer

'Fange mit der gesamten Liste an und untersuche dann
'immer ein Element weniger
For iUnsortEnd = sValue.Count To 1 Step -1
   iAktMin = 1
   'Finde das kleinste unsortierte Element
   For i = 2 To iUnsortEnd
      If sValue.Item(iAktMin) > sValue.Item(i) Then iAktMin = i
   Next i
   'Hnge das kleinste Element um
   sValue.Add(sValue.Item(iAktMin))
   sValue.Remove(iAktMin)
Next iUnsortEnd
End Sub 'SortStringList

'*****

Sub CorrectOutlineLevel(ByVal sFile As String, _
                        ByVal iMaxOutlineLevel As Integer)
'Verschiebt die Gliederungsebene des Dokuments "sFile", wenn diese
'hher ist, als "iMaxOutlineLevel" das vorgibt
'Erluterung siehe oben

   'Zeiger auf das aktuelle Dokument "sFile"
   Dim oSubDocument As Object
   'Zeiger auf das Fenster des Dokuments
   Dim oActiveWindow As Object
    'Hchste Gliederungsebene im Dokument
   Dim iActLevel As Integer
   Dim i As Integer, iParaStyle As Integer

   'Dokument "sFile" laden
   oSubDocument = Documents.Open(sFile)

   'Nun warte, bis das Dokument geladen ist
   Do While oSubDocument.IsLoading or oSubDocument.IsLoadingImages
      Wait 100
   Loop
   'Warte noch ein kleines bisschen, damit sich
   'StarOffice Writer richtig initialisieren kann
   Wait 100
   
   oActiveWindow = ActiveWindow

   'Bildschirmausgabe abstellen
   oActiveWindow.ActionStart()


   'Suche nach der hchsten Gliederungsebene im Dokument

   'StarOffice Suchoptionen setzen
   With oActiveWindow.SearchSettings
      .InSelection = False 'nicht nur im selektierten Text suchen
      .Backward = False 'nicht Rckwrts suchen
      .Pattern = True   'Suche nach Vorlagen einschalten
   End With

   'Suche dazu nach der Absatzvorlage "berschrift 1".
   'Falls es die gibt, ist iActLevel = 1,
   'sonst mache mit "berschrift 2" weiter

   iActLevel = 0
   Do While (oActiveWindow.Value() = "") and (iActLevel < 10)
      iActLevel = iActLevel + 1
      oActiveWindow.JumpToStartOfDoc()
      oActiveWindow.Search("berschrift " + iActLevel)
   Loop

   'Gliederungsebene korrigieren
   'Falls die gefundene maximale Gliederungsebene 1 ist
   'und die geforderte maximale Gliederungsebene 2 ist
   'Ersetze "berschrift 10" durch "Textkrper"
   'Ersetze "berschrift 9" durch "berschrift 10"
   'bis
   'Ersetze "berschrift 1" durch "berschrift 2"

   If iActLevel < iMaxOutlineLevel Then
      For i = 10 To 1 Step -1
         iParaStyle = i+(iMaxOutlineLevel-iActLevel)
         If iParaStyle > 10 Then
            oActiveWindow.ReplaceAll("berschrift " & i,"Textkrper")   
         Else
            oActiveWindow.ReplaceAll("berschrift " & i, _
                                     "berschrift " & iParaStyle)
         End If
      Next i
   End If

   'Bildschirmaktionen wieder anschalten
   oActiveWindow.ActionEnd()

   'Speichern des Dokuments ohne nachzufragen
   oSubDocument.Save()
   'und schlieen
   oSubDocument.Close(False, "")
End Sub 'CorrectOutlineLevel

'*****

Function StringHowManyTimesIn(ByVal sValue As String, _
                              ByVal sSearch As String) As Integer
'Hilfsfunktion zur Ermittlung der Gliederungsebene anhand der
'Verzeichnistiefe
'Zhlt das Auftauchen der Zeichenkette "sSearch" in "sValue"
   Dim iPos As Integer 'aktuelle Fundstelle
   'Wenn der Suchausdruck gefunden wurde, durchsuche "sValue"
   'ab dem Auffindeort weiter
   StringHowManyTimesIn = 0
   iPos = InStr(sValue, sSearch)
   Do While iPos > 0
      iPos = InStr(iPos + 1, sValue, sSearch)
      StringHowManyTimesIn = StringHowManyTimesIn + 1
   Loop
End Function 'StringHowManyTimesIn

'*****

Function GetDocInfos(ByVal sFile As String) As String
'Liest einige Dokumentinformationen aus "sFile" aus 
'und gibt sie als Zeichenkette zurck
   Dim oDocInfo As New Documentinfo 

   GetDocInfos = "Beginn der Datei: '" & sFile & "'"
   If oDocInfo.Load(sFile) Then
      GetDocInfos = GetDocInfos & chr(13) & _
                    "Titel: " & oDocInfo.Title & chr(13) & _
                    "Autor: " & oDocInfo.Author & chr(13) & _
                    "Thema: " & oDocInfo.Subject & chr(13) & _
                    "Schlsselworte: " & oDocInfo.KeyWords & chr(13) & _
                    "Beschreibung: " & oDocInfo.Description
   End If
   
   Erase oDocInfo
End Function 'GetDocInfos

