// FormatsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Formats.h"
#include "FormatsDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFormatsDlg dialog

CFormatsDlg::CFormatsDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFormatsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFormatsDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CFormatsDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFormatsDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFormatsDlg, CDialog)
	//{{AFX_MSG_MAP(CFormatsDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_CBN_SELCHANGE(IDC_LANGUAGE, OnSelchangeLanguage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFormatsDlg message handlers

BOOL CFormatsDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
    Languages.SubclassDlgItem(IDC_LANGUAGE, this);
    
    CString langtext;
    int idx;

    langtext.LoadString(IDS_SYSTEM_DEFAULT);                        
    idx = Languages.AddString( (LPCTSTR)langtext);
    Languages.SetItemData(idx, LOCALE_SYSTEM_DEFAULT);

    langtext.LoadString(IDS_GERMAN_GERMAN);                        
    idx = Languages.AddString( (LPCTSTR)langtext);
    Languages.SetItemData(idx, MAKELCID(MAKELANGID(LANG_GERMAN, SUBLANG_GERMAN), SORT_DEFAULT));

    langtext.LoadString(IDS_ENGLISH_US);                        
    idx = Languages.AddString( (LPCTSTR)langtext);
    Languages.SetItemData(idx, MAKELCID(MAKELANGID(LANG_ENGLISH, SUBLANG_ENGLISH_US), SORT_DEFAULT));

    langtext.LoadString(IDS_SPANISH_COLOMBIA);                        
    idx = Languages.AddString( (LPCTSTR)langtext);
    Languages.SetItemData(idx, MAKELCID(MAKELANGID(LANG_SPANISH, SUBLANG_SPANISH_COLOMBIA), SORT_DEFAULT));

    langtext.LoadString(IDS_SPANISH_BOLIVIA);                        
    idx = Languages.AddString( (LPCTSTR)langtext);
    Languages.SetItemData(idx, MAKELCID(MAKELANGID(LANG_SPANISH, SUBLANG_SPANISH_BOLIVIA), SORT_DEFAULT));

    langtext.LoadString(IDS_JAPANESE);                        
    idx = Languages.AddString( (LPCTSTR)langtext);
    Languages.SetItemData(idx, MAKELCID(MAKELANGID(LANG_JAPANESE, SUBLANG_DEFAULT), SORT_DEFAULT));

    Languages.SetCurSel(0);
    OnSelchangeLanguage();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CFormatsDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CFormatsDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CFormatsDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

#define DIMOF(x) (sizeof(x)/sizeof(*x))

void CFormatsDlg::SetData(LCID locale)
{
    double number;
    TCHAR  cformat[32], lformat[32];

    number = (double) -12345678 / 100;
    _stprintf( cformat, _T("%f"), number);

    // Anzeige als Zahl
    if (!GetNumberFormat(locale, 0, cformat, NULL,
                         lformat, DIMOF(lformat))) 
        _tcscpy(lformat, _T("******"));
    SetDlgItemText( IDC_NUMBER, lformat);

    // Anzeige als Whrung
    if (!GetCurrencyFormat(locale, 0, cformat, NULL,
                           lformat, DIMOF(lformat))) 
        _tcscpy(lformat, _T("******"));
    SetDlgItemText( IDC_CURRENCY, lformat);

    // Anzeige der aktuellen Zeit
    if (!GetTimeFormat(locale, 0, NULL, NULL,
                       lformat, DIMOF(lformat))) 
        _tcscpy(lformat, _T("******"));
    SetDlgItemText( IDC_TIME, lformat);

    // Anzeige der aktuellen Zeit
    if (!GetDateFormat(locale, DATE_LONGDATE, NULL, NULL,
                       lformat, DIMOF(lformat))) 
        _tcscpy(lformat, _T("******"));

    SetDlgItemText( IDC_DATE, lformat);
}

void CFormatsDlg::OnSelchangeLanguage() 
{
    LCID locale = (LCID) Languages.GetItemData(Languages.GetCurSel());
    
    SetData(locale);	
}
