//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MCIFrame.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

//---------------------------------------------------------------------------
__fastcall TMCISoundFrame::TMCISoundFrame(TComponent* Owner)
        : TFrame(Owner)
{
  EnableSoundButtons (false);

  unsigned long Volume;
  unsigned int LVolume;
  unsigned int RVolume;
  unsigned int Balance;
  waveOutGetVolume (0, (LPDWORD) &Volume);
  LVolume = Volume & 0xFFFF;
  RVolume = Volume >> 16;

// Die folgenden Voreinstellungen kann man auch im
// Objektinspektor treffen:
  TrackBarLoudness->Max = 65535;
  TrackBarLoudness->Frequency = TrackBarLoudness->Max / 6;
  TrackBarLoudness->LineSize = TrackBarLoudness->Max / 20;
  TrackBarLoudness->PageSize = TrackBarLoudness->Max / 5;
  TrackBarBalance->Max = 65535;
  TrackBarBalance->Frequency = TrackBarBalance->Max / 6;
  TrackBarBalance->LineSize = TrackBarBalance->Max / 20;
  TrackBarBalance->PageSize = TrackBarBalance->Max / 5;

// Aktuelle Schieberwerte einstellen:
  if (LVolume > RVolume)
    TrackBarLoudness->Position = TrackBarLoudness->Max - LVolume;
  else
    TrackBarLoudness->Position = TrackBarLoudness->Max -  RVolume;

  OldLoudness = TrackBarLoudness->Position;

  if ((LVolume == 0) && (RVolume == 0))
    Balance = TrackBarBalance->Max / 2;
  else
  if (LVolume > RVolume)
    Balance = TrackBarBalance->Max * RVolume / LVolume / 2;
  else
    Balance = TrackBarBalance->Max -
      TrackBarBalance->Max * LVolume / RVolume / 2;
  TrackBarBalance->Position = Balance;

// Anfangsverzeichnis einstellen:
//  StartDir = GetCurrentDir();
//  ShowMessage ("MCIFrame: " + StartDir);
}
//---------------------------------------------------------------------------

void __fastcall TMCISoundFrame::WndProc(Messages::TMessage &Message)
{
  switch (Message.Msg)
  {
    case MM_MCINOTIFY:
      switch (Message.WParam)
      {
        case MCI_NOTIFY_SUCCESSFUL:
          if (playing){
            if (paused){
              paused = false;
            }
            else {
              ToolButtonStop->Down = true;
              ToolButtonStop->Click();
            }
          }
          if (recording){
            if (paused){
              paused = false;
            }
          }
      };
      break;
    default: TFrame::WndProc (Message);
  };
}
//---------------------------------------------------------------------------
void __fastcall TMCISoundFrame::SpeedButtonLoadSoundClick(TObject *Sender)
{
  SoundOeffnenDialog->Filter = "Wave-Dateien (*.wav)|*.wav|Alle Dateien (*.*)|*.*";
  SoundOeffnenDialog->InitialDir = StartDir;
  SoundOeffnenDialog->Title = "Sounddatei laden";

  if (SoundOeffnenDialog->Execute()) {
    if (SoundOeffnenDialog->FileName != "") {
      SoundFileName->Caption = SoundOeffnenDialog->FileName;
      ScrollBoxSoundFileName->HorzScrollBar->Range = SoundFileName->Width;
      EnableSoundButtons (true);
    } // if FileNeme
  } // if SoundOeffnenDialog1->Execute()
}
//---------------------------------------------------------------------------
void __fastcall TMCISoundFrame::EnableSoundButtons (bool value)
{
  int i;
  for (i = 0; i < ToolBar1->ButtonCount - 3; i++)
    ToolBar1->Buttons [i]->Enabled = value;
}
//---------------------------------------------------------------------------

void __fastcall TMCISoundFrame::SpeedButtonSoundOnOffClick(TObject *Sender)
{
  if (SpeedButtonSoundOnOff->Down){
    OldLoudness = TrackBarLoudness->Position;
    TrackBarLoudness->Position = TrackBarLoudness->Max - TrackBarLoudness->Max / 10;
  }
  else {
    TrackBarLoudness->Position = OldLoudness;
  }
}
//---------------------------------------------------------------------------

void __fastcall TMCISoundFrame::ToolButtonRecordClick(TObject *Sender)
{
  SoundFileName->Caption = "Unnamed.wav";
  MCIERROR              error;
  MCI_OPEN_PARMS        mciOpen;
  MCI_RECORD_PARMS      mciRecord;

  mciOpen.dwCallback = 0;
  mciOpen.wDeviceID = 0;
  mciOpen.lpstrDeviceType = TEXT ("waveaudio");
  mciOpen.lpstrElementName = TEXT ("");
  mciOpen.lpstrAlias = NULL;

  error = mciSendCommand (0, MCI_OPEN, MCI_WAIT | MCI_OPEN_TYPE | MCI_OPEN_ELEMENT,
        (DWORD) &mciOpen);

  if (error != 0){
    ShowError (error);
    return;
  }

  // Gertekennung merken:
  wDeviceID = mciOpen.wDeviceID;

  SetRecordFormat(Sender);

  // Soundbuttons einschalten:

  EnableSoundButtons (true);
  ToolButtonStop->Down = false;

  // Aufnahme:

  mciRecord.dwCallback = (DWORD) Handle;
  mciRecord.dwFrom = 0;
  mciRecord.dwTo = 0;

  mciSendCommand (wDeviceID, MCI_RECORD, MCI_NOTIFY,
        (DWORD) &mciRecord);

  recording = true;
}
//---------------------------------------------------------------------------
void __fastcall TMCISoundFrame::SetRecordFormat(TObject *Sender)
{
  MCI_WAVE_SET_PARMS mciWaveSet;
  mciWaveSet.dwCallback  = 0;
  mciWaveSet.wFormatTag = WAVE_FORMAT_PCM;
  mciWaveSet.nChannels = 1;
  mciWaveSet.nSamplesPerSec = 22050;
  mciWaveSet.wBitsPerSample = 8;

  mciWaveSet.nChannels = RadioGroupMonoStereo->ItemIndex + 1;
  switch (RadioGroupSamplesPerSec->ItemIndex){
    case 0: mciWaveSet.nSamplesPerSec = 8000; break;
    case 1: mciWaveSet.nSamplesPerSec = 11025; break;
    case 2: mciWaveSet.nSamplesPerSec = 22050; break;
    case 3: mciWaveSet.nSamplesPerSec = 44100; break;
  }
  switch (RadioGroupBitsPerSample->ItemIndex){
    case 0: mciWaveSet.wBitsPerSample = 8; break;
    case 1: mciWaveSet.wBitsPerSample = 16; break;
  }

  mciWaveSet.nAvgBytesPerSec =
    mciWaveSet.nChannels * (mciWaveSet.wBitsPerSample / 8) * mciWaveSet.nSamplesPerSec;
  mciWaveSet.nBlockAlign =
    mciWaveSet.nChannels * (mciWaveSet.wBitsPerSample / 8);

  if (wDeviceID == 0) return;
  MCIERROR              error;
  error = mciSendCommand (wDeviceID, MCI_SET,
        MCI_WAIT|
        MCI_WAVE_SET_BITSPERSAMPLE | MCI_WAVE_SET_CHANNELS |
        MCI_WAVE_SET_SAMPLESPERSEC | MCI_WAVE_SET_AVGBYTESPERSEC |
        MCI_WAVE_SET_FORMATTAG | MCI_WAVE_SET_BLOCKALIGN,
        (DWORD) &mciWaveSet);
  if (error != 0)
    ShowError (error);
}
//---------------------------------------------------------------------------
void __fastcall TMCISoundFrame::ShowError (MCIERROR error)
{
  TCHAR szErrorStr [1024];

  mciGetErrorString (error, szErrorStr, sizeof (szErrorStr) / sizeof (TCHAR));
  ShowMessage (szErrorStr);
}
//---------------------------------------------------------------------------

void __fastcall TMCISoundFrame::ToolButtonPauseClick(TObject *Sender)
{
  ToolBar1->Update();

  if (ToolButtonPause->Down){
    if (playing){
      ToolButtonPlay->Enabled = false;
      ToolButtonPlay->Down = false;
    }
    if (recording){
      ToolButtonRecord->Enabled = false;
      ToolButtonRecord->Down = false;
    }
    paused = true;
    MCI_GENERIC_PARMS mciGeneric;
    mciGeneric.dwCallback = 0;
    mciSendCommand (wDeviceID, MCI_PAUSE, MCI_WAIT,
                    (DWORD) &mciGeneric);
  }
  else {
    if (playing){
      ToolButtonPlay->Down = true;
      ToolButtonPlay->Enabled = true;
    }
    if (recording){
      ToolButtonRecord->Down = true;
      ToolButtonRecord->Enabled = true;
    }
    MCI_GENERIC_PARMS mciGeneric;
    mciGeneric.dwCallback = (DWORD) Handle;
    mciSendCommand (wDeviceID, MCI_RESUME, MCI_NOTIFY,
                (DWORD) &mciGeneric);
  }

}
//---------------------------------------------------------------------------

void __fastcall TMCISoundFrame::ToolButtonStopClick(TObject *Sender)
{
  MCI_GENERIC_PARMS mciGeneric;
  if (playing){
    ToolButtonPause->Down = false;
    mciGeneric.dwCallback = 0;
    mciSendCommand (wDeviceID, MCI_STOP, MCI_WAIT,
                    (DWORD) &mciGeneric);
    mciSendCommand (wDeviceID, MCI_CLOSE, MCI_WAIT,
                    (DWORD) &mciGeneric);

    playing = false;
  } // if playing

  if (recording){
    ToolButtonRecord->Down = false;
    mciGeneric.dwCallback = 0;
    mciSendCommand (wDeviceID, MCI_STOP, MCI_WAIT,
                    (DWORD) &mciGeneric);

// Datei speichern:
    bool doAutoSave = true;
    AnsiString WFileName = SoundFileName->Caption;

    if (FEndRecordEvent)
      FEndRecordEvent (this, doAutoSave, WFileName);

    if (doAutoSave){
      SoundSpeichernDialog->Filter = "Wave-Dateien (*.wav)|*.wav|Alle Dateien (*.*)|*.*";
      SoundSpeichernDialog->InitialDir = StartDir; //GetCurrentDir ();
      SoundSpeichernDialog->FileName = WFileName;
      SoundSpeichernDialog->Title = "Sounddatei speichern";

      if (SoundSpeichernDialog->Execute()) {
        WFileName = SoundSpeichernDialog->FileName;
      }
    } // if (doAutoSave)

    if (WFileName != ""){
      MCI_SAVE_PARMS mciSave;
      mciSave.dwCallback = 0;
      if (ExtractFileExt (WFileName) == "")
        WFileName = WFileName + ".wav";
      SoundFileName->Caption = WFileName;
      ScrollBoxSoundFileName->HorzScrollBar->Range = SoundFileName->Width;
      mciSave.lpfilename = WFileName.c_str();

      mciSendCommand (wDeviceID, MCI_SAVE, MCI_WAIT | MCI_SAVE_FILE,
                      (DWORD) &mciSave);
    } // if SoundSpeichern

// Audiogert schlieen
    mciSendCommand (wDeviceID, MCI_CLOSE, MCI_WAIT,
                    (DWORD) &mciGeneric);
    recording = false;
  } // if recording
  wDeviceID = 0;

}
//---------------------------------------------------------------------------

void __fastcall TMCISoundFrame::ToolButtonPlayClick(TObject *Sender)
{
  if (playing) return;

  playing = true;
  ToolBar1->Update();

  MCIERROR              error;
  MCI_OPEN_PARMS        mciOpen;
  MCI_PLAY_PARMS        mciPlay;
  TCHAR                 FileName [1024];

  if (SoundFileName->Caption != ""){
      mciOpen.dwCallback = 0;
      mciOpen.wDeviceID = 0;
      mciOpen.lpstrDeviceType = NULL;
// ohne diesen Umweg ber FileName werden ev. Zeichen abgeschnitten -
// SoundFileName->Caption liefert nur einen
// temporren String, der zwischengespeichert werden mu!
      strcpy (FileName, SoundFileName->Caption.c_str());
      mciOpen.lpstrElementName = FileName;
      mciOpen.lpstrAlias = NULL;
      error = mciSendCommand (0, MCI_OPEN, MCI_WAIT | MCI_OPEN_ELEMENT,
                              (DWORD) &mciOpen);

      if (error != 0){
        ShowError (error);
        wDeviceID = 0;
        return;}
      else{
        wDeviceID = mciOpen.wDeviceID;
      }; // else
  }

  mciPlay.dwCallback = (DWORD) Handle; //PanelKomponente->Handle;
  mciPlay.dwFrom = 0;
  mciPlay.dwTo = 0;
  error = mciSendCommand (wDeviceID, MCI_PLAY, MCI_NOTIFY /*MCI_WAIT*/,
                (DWORD) &mciPlay);

  if (error != 0){
    ShowError (error);
  }

}
//---------------------------------------------------------------------------

void __fastcall TMCISoundFrame::TrackBarLoudnessChange(TObject *Sender)
{
  unsigned int Volume;
  unsigned int  LVolume;
  unsigned int  RVolume;
  unsigned int  Balance;
  Volume = TrackBarLoudness->Max - TrackBarLoudness->Position;
  if (TrackBarBalance->Position < TrackBarBalance->Max / 2){ // Left > Right
    LVolume = Volume;
    Balance = TrackBarBalance->Position * 2;
    RVolume = Volume * Balance / TrackBarBalance->Max;
  }
  else{
    RVolume = Volume;
    Balance = (TrackBarBalance->Max - TrackBarBalance->Position) * 2;
    LVolume = Volume * Balance / TrackBarBalance->Max;
  };
  Volume = LVolume + (RVolume << 16);
  waveOutSetVolume (0, (DWORD) Volume);

}
//---------------------------------------------------------------------------

void __fastcall TMCISoundFrame::TrackBarLoudnessKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
  if ((Key == VK_LEFT) || (Key == VK_RIGHT))
    Key = 0;

}
//---------------------------------------------------------------------------

void __fastcall TMCISoundFrame::TrackBarBalanceKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
  switch (Key){
    case VK_UP:;
    case VK_DOWN: Key = 0; break;
    case VK_PRIOR: Key = VK_NEXT; break;
    case VK_NEXT: Key = VK_PRIOR; break;
  };

}
//---------------------------------------------------------------------------

void __fastcall TMCISoundFrame::ButtonOkClick(TObject *Sender)
{
  dynamic_cast <TForm *> (Owner)->Close();
}
//---------------------------------------------------------------------------


__fastcall TMCISoundFrame::~TMCISoundFrame()
{
        //TODO: Hier Ihren Quelltext einfgen
  if (wDeviceID == 0) return;

  MCI_GENERIC_PARMS mciGeneric;

  mciGeneric.dwCallback = 0;
  mciSendCommand (wDeviceID, MCI_STOP, MCI_WAIT,
                  (DWORD) &mciGeneric);
  mciSendCommand (wDeviceID, MCI_CLOSE, MCI_WAIT,
                  (DWORD) &mciGeneric);
}
