/* Grafische Komponentenentwicklung
   (C) 2000 by Johannes Leckebusch
   Datum: 20. 8. 2000 */
//---------------------------------------------------------------------------

#ifndef MCIFrameKompH
#define MCIFrameKompH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <ComCtrls.hpp>
#include <Dialogs.hpp>
#include <ExtCtrls.hpp>
#include <ImgList.hpp>
#include <ToolWin.hpp>
#include <MPlayer.hpp>
//---------------------------------------------------------------------------
typedef void __fastcall (__closure *TEndRecordEvent)
  (TObject* Sender, bool& doStandard, AnsiString &SoundName);

//class PACKAGE TMCISoundFrameKomp : public TFrame
class TMCISoundFrameKomp : public TFrame
{
__published:	// Von der IDE verwaltete Komponenten
        TGroupBox *SoundFileInfo;
        TScrollBox *ScrollBoxSoundFileName;
        TLabel *SoundFileName;
        TImageList *ImageListSoundbuttons;
        TSaveDialog *SoundSpeichernDialog;
        TOpenDialog *SoundOeffnenDialog;
        TPanel *PanelTrackbars;
        TPanel *PanelModus;
        TToolBar *ToolBar1;
        TToolButton *ToolButtonPlay;
        TToolButton *ToolButtonStop;
        TToolButton *ToolButton1;
        TToolButton *ToolButtonPause;
        TToolButton *ToolButton3;
        TToolButton *ToolButtonRecord;
        TSpeedButton *SpeedButtonLoadSound;
        TSpeedButton *SpeedButtonSoundOnOff;
        TRadioGroup *RadioGroupMonoStereo;
        TRadioGroup *RadioGroupSamplesPerSec;
        TRadioGroup *RadioGroupBitsPerSample;
        TTrackBar *TrackBarLoudness;
        TTrackBar *TrackBarBalance;
        TLabel *LabelLautstaerke;
        TLabel *Label1;
        void __fastcall SpeedButtonLoadSoundClick(TObject *Sender);
        void __fastcall SpeedButtonSoundOnOffClick(TObject *Sender);
        void __fastcall ToolButtonRecordClick(TObject *Sender);
        void __fastcall SetRecordFormat(TObject *Sender);
        void __fastcall ToolButtonPauseClick(TObject *Sender);
        void __fastcall ToolButtonStopClick(TObject *Sender);
        void __fastcall ToolButtonPlayClick(TObject *Sender);
        void __fastcall TrackBarLoudnessChange(TObject *Sender);
        void __fastcall TrackBarLoudnessKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall TrackBarBalanceKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall ButtonOkClick(TObject *Sender);
private:	// Anwender-Deklarationen
        TMemoryStream   *SoundStream;
        MCIDEVICEID     wDeviceID;
        int             OldLoudness;
        bool            playing;
        bool            recording;
        bool            paused;
        void __fastcall ShowError (MCIERROR error);
        TEndRecordEvent  FEndRecordEvent;
protected:
        void __fastcall WndProc(Messages::TMessage &Message);
public:		// Anwender-Deklarationen
        __fastcall TMCISoundFrameKomp(TComponent* Owner);
        void __fastcall EnableSoundButtons (bool value);
        AnsiString      StartDir;
        __fastcall ~TMCISoundFrameKomp();
        bool __fastcall LoadSoundFile (AnsiString filename);
        bool __fastcall PlaySoundFile();
        void __fastcall StopSound();
        bool __fastcall RecordSoundFile();
__published:
        __property TEndRecordEvent OnEndRecord =
          {read = FEndRecordEvent, write = FEndRecordEvent};
};
//---------------------------------------------------------------------------
extern PACKAGE TMCISoundFrameKomp *MCISoundFrameKomp;
//---------------------------------------------------------------------------
#endif
