/* Grafische Komponentenentwicklung
   (C) 2000 by Johannes Leckebusch
   Datum: 05. 8. 2000 */
//---------------------------------------------------------------------------

#include <vcl.h>
#include <Filectrl.hpp>
#pragma hdrstop

#include "MCISoundDlg.h"
#include "FormDlg.h"
#pragma package(smart_init)
#pragma resource "mcisounddlg.dcr"
//---------------------------------------------------------------------------
// ValidCtrCheck wird benutzt, um sicherzustellen, da die erzeugten Komponenten
// keine rein virtuellen Funktionen besitzen.
//

static inline void ValidCtrCheck(TMCISoundDlg *)
{
        new TMCISoundDlg(NULL);
}
//---------------------------------------------------------------------------
__fastcall TMCISoundDlg::TMCISoundDlg(TComponent* Owner)
        : TComponent(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMCISoundDlg::SetInitialDir (AnsiString value)
{
  if (DirectoryExists (value))
    FSoundDir = value;
}
//---------------------------------------------------------------------------
AnsiString __fastcall TMCISoundDlg::GetInitialDir()
{
  return FSoundDir;
}
//---------------------------------------------------------------------------
bool __fastcall TMCISoundDlg::Execute(AnsiString LoadFile, bool PlayFile)
{
  FormSoundDlg = new TFormSoundDlg (Application); // Dialogfeld erzeugen
  bool Result;
  try
  {
    FormSoundDlg->MCISoundFrameKomp1->OnEndRecord = OnEndRecord;
    if (FSoundDir != "")
     FormSoundDlg->MCISoundFrameKomp1->StartDir = FSoundDir;

    if (LoadFile != "")
      FormSoundDlg->MCISoundFrameKomp1->LoadSoundFile (LoadFile);

    if (PlayFile)
      FormSoundDlg->MCISoundFrameKomp1->PlaySoundFile();

    Result = (FormSoundDlg->ShowModal() == IDOK);
    if (Result)
      FSoundDir = FormSoundDlg->MCISoundFrameKomp1->StartDir;
//    FormSoundDlg->Show();
  }
  catch (EInvalidOperation&)
  {
    Result = false;
  }

  FormSoundDlg->Free();
  return Result == IDOK;
}

//---------------------------------------------------------------------------
void __fastcall TMCISoundDlg::SetEndRecordEvent (TEndRecordEvent EndREvent)
{
//  FormSoundDlg->MCISoundFrameKomp1->OnEndRecord = EndREvent;
  FEndRecordEvent = EndREvent;
}
//---------------------------------------------------------------------------
TEndRecordEvent __fastcall TMCISoundDlg::GetEndRecordEvent ()
{
//  return FormSoundDlg->MCISoundFrameKomp1->OnEndRecord;
  return FEndRecordEvent;
}
//---------------------------------------------------------------------------
namespace Mcisounddlg
{
        void __fastcall PACKAGE Register()
        {
                 TComponentClass classes[1] = {__classid(TMCISoundDlg)};
                 RegisterComponents("Sound", classes, 0);
        }
}
//---------------------------------------------------------------------------
