#include <kio/slavebase.h>
#include <kinstance.h>
#include <kdebug.h>
#include <stdlib.h>
#include <qtextstream.h>

class HelloProtocol : public KIO::SlaveBase
{
public:
    HelloProtocol( const QCString &pool, const QCString &app)
        : SlaveBase( "hello", pool, app ) {}
    virtual void get( const KURL& url );
};

extern "C" {
    int kdemain( int, char **argv )
    {
        KInstance instance( "kio_hello" );
        HelloProtocol slave(argv[2], argv[3]);
        slave.dispatchLoop();
        return 0;
    }
}

void HelloProtocol::get( const KURL& url )
{
    // tell the mimetype
    mimeType("text/html");

    QString name = url.path();
    if (name.isEmpty() || name == "/")
        name = "C't Readers";
    else
        name = name.mid(1); // strip leading /

    QCString output;
    output.sprintf("<HTML>\n"
                   "<BODY>Hello %s</BODY>\n"
                   "</HTML>\n", name.latin1());

    data(output);
    finished();
}
