/*****************************************************************************
 *
 * Created with Falch.net DeveloperStudio
 * http://www.falch.net/
 * 
 * Created : 28.02.2001 15:42:34
 * Creator : mrkor
 *
 ****************************************************************************/
#include <PalmOS.h>

#include "Euro.h"
#include "Euro_res.h"

/****************************************************************************/

/* ein paar Vorbereitungen */
static void InitialisiereForm()
{
	FormPtr	form;

	form=FrmGetActiveForm(); 	

	fieldptr_Euro = 	FrmGetObjectPtr( form,
							FrmGetObjectIndex(form, fieldEuro) );
	fieldptr_Cent = 	FrmGetObjectPtr( form,
							FrmGetObjectIndex(form, fieldCent) );
	fieldptr_DM = 		FrmGetObjectPtr( form,
							FrmGetObjectIndex(form, fieldDM) );
	fieldptr_Pfennige =	FrmGetObjectPtr( form,
							FrmGetObjectIndex(form, fieldPfennige) );
}

static int StartApplication(void)
{
	FrmGotoForm(frmMain);
	return 0;
}

static Boolean ApplicationHandleEvent(EventPtr event)
{
	UInt16 formID;
	FormPtr form;
	Boolean handled = false;
	
	// Application event loop
	switch (event->eType)
	{
		case frmOpenEvent:
			InitialisiereForm();		
			break;
	
		case menuEvent:
			// Set event handler for application
			handled = ApplicationHandleMenu(event->data.menu.itemID);
			break;

		case frmLoadEvent:
			// Handle form load events
			formID = event->data.frmLoad.formID;
			form = FrmInitForm(formID);
			FrmSetActiveForm(form);		
			switch (formID)
			{
				case frmMain:
					// Set event handler for frmMain
					FrmSetEventHandler(form, 
						(FormEventHandlerPtr) frmMain_HandleEvent);
					break;
			}
			handled = true;
			break;
		default:
			break;
	}
	return handled;
}

static void EventLoop(void)
{
	UInt16 error;
	EventType event;

	// Main event loop
	do
	{
		// Get next event
		EvtGetEvent(&event, evtWaitForever);
	
		// Handle event
		if (!SysHandleEvent(&event))
		{
			if (!MenuHandleEvent(0, &event, &error))
			{
				if (!ApplicationHandleEvent(&event))
					FrmDispatchEvent(&event);	
			}
		}
	}
	while (event.eType != appStopEvent);
}

static void StopApplication(void)
{
	// Insert stop code here
	FrmCloseAllForms();
}

/***********************/
/* Test der OS-Version */
/***********************/
Boolean DeviceSupportsVersion(UInt32 version)
{
  UInt32 romVersion;

  FtrGet(sysFtrCreator, sysFtrNumROMVersion, &romVersion);
  return (romVersion >= version);
}

/****************************************************************************/
UInt32 PilotMain(UInt16 cmd, void *cmdPBP, UInt16 launchFlags)
{
	int error;
	
	if (cmd == sysAppLaunchCmdNormalLaunch)
 	{
		/* fr Fliekommaberechnung wird mind. PalmOS 2.0 bentigt */
		if (DeviceSupportsVersion(
			sysMakeROMVersion(2,0,0,sysROMStageRelease,0))==true)
		{
			// Application start code
			error = StartApplication();
			if (error)
				return error;
		
			// Maintain event loop
			EventLoop();

			// Stop application 
			StopApplication();
		}
		else
			FrmAlert(alertVersion); /* ansonsten Fehlermeldung ausgeben und Programmende */	
	}
	return 0;
}

/****************************************************************************/

