/*****************************************************************************
 *
 * Created with Falch.net DeveloperStudio
 * http://www.falch.net/
 * 
 * Created : 28.02.2001 15:42:34
 * Creator : mrkor
 *
 ****************************************************************************/
#include <PalmOS.h>
#include "Euro.h"
#include "Euro_res.h"   

/*** Field-Control berschreiben ***/
static void BeschreibeField(FieldPtr ptr, char *text)
{
	// alten Inhalt rauswerfen
	FldDelete(ptr,0,FldGetTextLength(ptr));
	// und gleich berschreiben
	FldInsert(ptr,text,StrLen(text));
}

/*** Field-Control auslesen ***/ 
static UInt32 LeseField(FieldPtr ptr)
{
	if (ptr->text != NULL)
		return StrAToI(ptr->text);
	else
		return 0;				
}

/*** Umrechnung von Euro in DM ***/
static Boolean frmMain_cmdEuroDM_OnSelect(EventPtr event)
{
	UInt32 dm,euro,pfennige,cent;
	double betrag;
	char text[20];
	
	/* Fields auslesen und Betrag in Cents ablegen */
	euro=LeseField(fieldptr_Euro); /* Euro auslesen */
	cent=LeseField(fieldptr_Cent); /* Cent auslesen */

	betrag=euro*100+cent;			 															
	betrag*=1.95583; 	/* Umrechnen */	
	
	dm=betrag/100;		/* DM ermitteln */

	betrag-=dm*100;		/* nur die Pfennige brig lassen */		
	pfennige=betrag;		
	
	betrag-=pfennige;	/* Nachkommastelle herauspicken */	
	if (betrag>=0.5)	/* und eventuell aufrunden */
		pfennige++;

	if (pfennige==100)	/* den "Pfennig-Gau"  bercksichtigen*/	
		{ pfennige=0;	dm++;}
		
	StrPrintF(text,"%ld", dm);	/* Mark ausgeben */
	BeschreibeField(fieldptr_DM, text);
																
	StrPrintF(text,"%02ld", pfennige);	/* Pfennige ausgeben */
	BeschreibeField(fieldptr_Pfennige, text);		
	
	return true;
}

/*** Umrechnung von DM in Euro ***/
static Boolean frmMain_cmdDMEuro_OnSelect(EventPtr event)
{
	UInt32 dm,euro,cent,pfennige;
	double betrag;
	char text[20];

	/* Fields auslesen und Betrag in Pfennigen ablegen */
	dm=LeseField(fieldptr_DM);	
	pfennige=LeseField(fieldptr_Pfennige); 

	betrag=dm*100+pfennige;			 															
	betrag/=1.95583; 		/* Umrechnen */	
	
	euro=betrag/100;		/* Euro ermitteln */

	betrag-=euro*100;		/* nur die Cents brig lassen */		
	cent=betrag;			
	
	betrag-=cent;			/* Nachkommastelle herauspicken */	
	if (betrag>=0.5)		/* und eventuell aufrunden */
		cent++;	

	if (cent==100)			/* den "Cent-Gau"  bercksichtigen*/
	{	cent=0;	euro++;	}

	StrPrintF(text,"%ld", euro);		/* Euro ausgeben */
	BeschreibeField(fieldptr_Euro, text);
																
	StrPrintF(text,"%02ld",cent);	/* Cent ausgeben */															
	BeschreibeField(fieldptr_Cent, text);

	return true;
}

Boolean frmMain_HandleEvent(EventPtr event)
{
	FormPtr form;
	Boolean handled = false;

	switch (event->eType)
	{
		case ctlSelectEvent:
			switch (event->data.ctlSelect.controlID)
			{
				// cmdEuroDM receives an event
				case cmdEuroDM:
					handled = frmMain_cmdEuroDM_OnSelect(event);
					break;
				// cmdDMEuro receives an event
				case cmdDMEuro:
					handled = frmMain_cmdDMEuro_OnSelect(event);
					break;
			}
			break;
		case frmOpenEvent:
			// Repaint form on open
			form = FrmGetActiveForm();
			FrmDrawForm(form);
						
			/*** Field-Initialisierung ****/
			BeschreibeField(fieldptr_Euro,"0");
			BeschreibeField(fieldptr_Cent,"00");
			BeschreibeField(fieldptr_DM,"0");
			BeschreibeField(fieldptr_Pfennige,"00");			

			handled = true;
			break;
		default:
			return false;
	}
	return handled;
}
