#include "vc.h"

#define MakePtr(c,p,o)	(c)((UINT32)p + ((UINT32)o))

/////////////////////////////////////////////////////////////////////////////
// the functions to intercept:
scFunction	__FunctionList[] =
	{
	 {FCT_CREATEPROCESS,		TEXT("kernel32.dll"),		"CreateProcessA",			CS_SBCS,   10, NULL},
	 {FCT_CREATEPROCESS,		TEXT("kernel32.dll"),		"CreateProcessW",			CS_UNI,    10, NULL},
	 {FCT_CREATEPROCESSASUSER,	TEXT("kernel32.dll"),		"CreateProcessAsUserA",		CS_SBCS,   11, NULL},
	 {FCT_CREATEPROCESSASUSER,	TEXT("kernel32.dll"),		"CreateProcessAsUserW",		CS_UNI,    11, NULL},
	 {FCT_WINEXEC,				TEXT("kernel32.dll"),		"WinExec",					CS_SBCS,	2, NULL},
	 {FCT_SHELLEXECUTE,			TEXT("shell32.dll"),		"ShellExecuteA",			CS_SBCS,	6, NULL},
	 {FCT_SHELLEXECUTE,			TEXT("shell32.dll"),		"ShellExecuteW",			CS_UNI,		6, NULL},
	 {FCT_SHELLEXECUTEEX,		TEXT("shell32.dll"),		"ShellExecuteExA",	 		CS_SBCS,	1, NULL},
	 {FCT_SHELLEXECUTEEX,		TEXT("shell32.dll"),		"ShellExecuteExW",	 		CS_UNI,		1, NULL},
	 {FCT_SHELLLOADINPROC,		TEXT("shell32.dll"),		"SHLoadInProc",	 			CS_NONE,	1, NULL},
	 {FCT_COCREATEINSTANCE,		TEXT("ole32.dll"),			"CoCreateInstance",			CS_NONE,	5, NULL},
	 {FCT_COCREATEINSTANCEEX,	TEXT("ole32.dll"),			"CoCreateInstanceEx",		CS_NONE,	6, NULL},
	 {FCT_COGETCLASSOBJECT,		TEXT("ole32.dll"),			"CoGetClassObject",			CS_NONE,	5, NULL},
	 {FCT_COGETINSTANCEFROMFILE,TEXT("ole32.dll"), 			"CoGetInstanceFromFile",	CS_NONE,	7, NULL},
	 {FCT_COGETINSTANCEFROMISTORAGE,TEXT("ole32.dll"), 		"CoGetInstanceFromIStorage",CS_NONE,    7, NULL},
	 {FCT_OLECREATE,		 	TEXT("ole32.dll"),			"OleCreate",				CS_NONE,	7, NULL},
	 {FCT_OLECREATEEX,		 	TEXT("ole32.dll"),			"OleCreateEx",				CS_NONE,   12, NULL},
	 {FCT_OLECREATEFROMFILE, 	TEXT("ole32.dll"),			"OleCreateFromFile",		CS_NONE,	8, NULL},
	 {FCT_OLECREATEFROMFILEEX, 	TEXT("ole32.dll"),			"OleCreateFromFileEx",		CS_NONE,   13, NULL},
	 {FCT_CREATEFILE,			TEXT("kernel32.dll"),		"CreateFileA",				CS_SBCS,	7, NULL},
	 {FCT_CREATEFILE,			TEXT("kernel32.dll"),		"CreateFileW",				CS_UNI,		7, NULL},
	 {FCT_MOVEFILE,				TEXT("kernel32.dll"),		"MoveFileA",				CS_SBCS,	2, NULL},
	 {FCT_MOVEFILE,				TEXT("kernel32.dll"),		"MoveFileW",				CS_UNI,		2, NULL},
	 {FCT_MOVEFILEEX, 			TEXT("kernel32.dll"),		"MoveFileExA",				CS_SBCS,	3, NULL},
	 {FCT_MOVEFILEEX, 			TEXT("kernel32.dll"),		"MoveFileExW",				CS_UNI,		3, NULL},
	 {FCT_COPYFILE,				TEXT("kernel32.dll"),		"CopyFileA",				CS_SBCS,	3, NULL},
	 {FCT_COPYFILE,				TEXT("kernel32.dll"),		"CopyFileW",				CS_UNI,		3, NULL},
	 {FCT_COPYFILEEX,			TEXT("kernel32.dll"),		"CopyFileExA",				CS_SBCS,	6, NULL},
	 {FCT_COPYFILEEX,			TEXT("kernel32.dll"),		"CopyFileExW",				CS_UNI,		6, NULL},
	 {FCT_DELETEFILE, 			TEXT("kernel32.dll"),		"DeleteFileA",				CS_SBCS,	1, NULL},
	 {FCT_DELETEFILE, 			TEXT("kernel32.dll"),		"DeleteFileW",				CS_UNI,		1, NULL},
	 {FCT_LOADLIBRARY, 			TEXT("kernel32.dll"),		"LoadLibraryA",				CS_SBCS,    1, NULL},
	 {FCT_LOADLIBRARY, 			TEXT("kernel32.dll"),		"LoadLibraryW",				CS_UNI,     1, NULL},
	 {FCT_LOADLIBRARYEX,		TEXT("kernel32.dll"),		"LoadLibraryExA",			CS_SBCS,    3, NULL},
	 {FCT_LOADLIBRARYEX,		TEXT("kernel32.dll"),		"LoadLibraryExW",			CS_UNI,     3, NULL},
	 {FCT_GETPROCADDRESS,		TEXT("kernel32.dll"),		"GetProcAddress",			CS_SBCS,    2, NULL},
#if 0 // set this to 1 if registry functions should be intercepted too!
	 {FCT_REGCREATEKEY,			TEXT("advapi32.dll"),		"RegCreateKeyA",			CS_SBCS,    3, NULL},
	 {FCT_REGCREATEKEY,			TEXT("advapi32.dll"),		"RegCreateKeyW",			CS_UNI,    	3, NULL},
	 {FCT_REGCREATEKEYEX,		TEXT("advapi32.dll"),		"RegCreateKeyExA",			CS_SBCS,    9, NULL},
	 {FCT_REGCREATEKEYEX,		TEXT("advapi32.dll"),		"RegCreateKeyExW",			CS_UNI,    	9, NULL},
	 {FCT_REGOPENKEY,			TEXT("advapi32.dll"),		"RegOpenKeyA",				CS_SBCS,    3, NULL},
	 {FCT_REGOPENKEY,			TEXT("advapi32.dll"),		"RegOpenKeyW",				CS_UNI,    	3, NULL},
	 {FCT_REGOPENKEYEX,			TEXT("advapi32.dll"),		"RegOpenKeyExA",  			CS_SBCS,    5, NULL},
	 {FCT_REGOPENKEYEX,			TEXT("advapi32.dll"),		"RegOpenKeyExW",  			CS_UNI,    	5, NULL},
	 {FCT_REGCLOSEKEY,			TEXT("advapi32.dll"),		"RegCloseKey",				CS_NONE,   	1, NULL},
	 {FCT_REGDELETEKEY,			TEXT("advapi32.dll"),		"RegDeleteKeyA",			CS_SBCS,   	2, NULL},
	 {FCT_REGDELETEKEY,			TEXT("advapi32.dll"),		"RegDeleteKeyW",			CS_UNI,   	2, NULL},
	 {FCT_REGSETVALUE,			TEXT("advapi32.dll"),		"RegSetValueA",				CS_SBCS,   	5, NULL},
	 {FCT_REGSETVALUE,			TEXT("advapi32.dll"),		"RegSetValueW",				CS_UNI,   	5, NULL},
	 {FCT_REGSETVALUEEX, 		TEXT("advapi32.dll"),		"RegSetValueExA",			CS_SBCS,   	6, NULL},
	 {FCT_REGSETVALUEEX, 		TEXT("advapi32.dll"),		"RegSetValueExW",			CS_UNI,   	6, NULL},
	 {FCT_REGQUERYVALUE,		TEXT("advapi32.dll"),		"RegQueryValueA",  			CS_SBCS,   	4, NULL},
	 {FCT_REGQUERYVALUE,		TEXT("advapi32.dll"),		"RegQueryValueW",  			CS_UNI,   	4, NULL},
	 {FCT_REGQUERYVALUEEX, 		TEXT("advapi32.dll"),		"RegQueryValueExA",			CS_SBCS,   	6, NULL},
	 {FCT_REGQUERYVALUEEX, 		TEXT("advapi32.dll"),		"RegQueryValueExW",			CS_UNI,   	6, NULL},
#endif
	 {FCT_END},
	};

/////////////////////////////////////////////////////////////////////////////
// the API stub assembler code structure
#pragma pack(push,1)
struct APIFunction
	{
		UINT32		_RealProcAddress;
		UINT8		_instr_start;
		UINT8		_instr_push_eax_as_retval;		   	// push		eax ; will be set to return value
		UINT8		_instr_push_eax_as_flag;		   	// push		eax ; will be set to decision flag
		UINT32		_instr_lea_eax_esp_plus_8;		   	// lea		eax,[esp]+8
		UINT8		_instr_push_eax;					// push 	eax
		UINT8		_instr_push_offset_function;		// push		scAPIFunction*
		UINT32		_offset_function;	
		UINT8		_instr_call_interceptor;			// call		Interceptor()
		UINT32		_offset_interceptor;
		UINT8		_instr_pop_eax_flag; 				// pop 		eax ; 0 if org function should be suppressed
		UINT16		_instr_test_eax_eax;				// test		eax, eax
		UINT8		_instr_pop_eax_retval;				// pop 		eax ; return value if suppression value is 0
		UINT16		_instr_jne_plus_3;					// jnc		$+3
		UINT8		_instr_ret_pop_amount;				// pop		nr_of_parameters * sizeof(UINT32)
		UINT16		_instr_ret_amount;
		UINT16		_instr_jmp_dword_ptr_origaddress;	// jmp		[_RealProcAddress]
		UINT32		_offset_origaddress;

		// allocate this thunk in global memory that will not be freed when the DLL is unloaded!
		void*		operator new(size_t s)	 { return((void*)GlobalAlloc(GMEM_FIXED,s)); }
		void		operator delete(void* p) { GlobalFree((HGLOBAL)p); }
	};	
#pragma pack(pop)	
	
/////////////////////////////////////////////////////////////////////////////
// some STL helpers...
#if USE_STL
	struct eqptr
	{
	  	bool operator()(void* p1, void* p2) const { return(p1 == p2); }
	};

	#if defined(_MSC_VER)
		typedef map<void*,APIFunction*,less<void*>,allocator<APIFunction*> >	THUNKLIST;
		typedef map<void*,DWORD*,less<void*>,allocator<DWORD*> >				ADDRESSLIST;
		THUNKLIST																__ThunkList;
		ADDRESSLIST																__OldAddressList; 
		typedef THUNKLIST::iterator												APIIter;
		typedef ADDRESSLIST::iterator											HookIter;	
	  #else
		struct hash<void*>
		{
	  		size_t operator()(void* __x) const { return((size_t)__x); }
		};

		hash_map<void*,APIFunction*,hash<void*>,eqptr>							__ThunkList;
		hash_map<void*,DWORD*,hash<void*>,eqptr>								__OldAddressList; 
		typedef hash_map<void*,APIFunction*,hash<void*>,eqptr>::const_iterator	APIIter;
		typedef hash_map<void*,DWORD*,hash<void*>,eqptr>::const_iterator		HookIter;
	#endif // defined(_MSC_VER)
  #else
	WCValSkipListDict<void*,APIFunction*>									__ThunkList;
	WCValSkipListDict<void*,DWORD*>											__OldAddressList;
	typedef WCValSkipListDictIter<void*,APIFunction*>						APIIter;
#endif	


/////////////////////////////////////////////////////////////////////////////
// creates the API stub structure and fills it with code
void	BuildAPIStub(scFunction* pscFunction)
{
	// thunk already created?
	if (pscFunction->_pfnOrgAddress != NULL)
		return;
		
	HookDebug("BuildAPIStub(%s::%s)",pscFunction->_pszModule,pscFunction->_pszName);

	HMODULE	hModule = GetModuleHandle(pscFunction->_pszModule);
	if (hModule == NULL)
		{
		HookDebug(" *** BuildAPIStub(%s::%s) failed (GetModuleHandle)",pscFunction->_pszModule,pscFunction->_pszName);
		return;
		}
	
	pscFunction->_pfnOrgAddress = GetProcAddress(hModule,pscFunction->_pszName);
	if (pscFunction->_pfnOrgAddress == NULL)
		{
		HookDebug(" *** BuildAPIStub(%s::%s) failed (GetProcAddress)",pscFunction->_pszModule,pscFunction->_pszName);
		return;
		}
	
	// already thunked? (redundant check, but you never know...)
	if (LIST_CONTAINS(__ThunkList,pscFunction->_pfnOrgAddress))
		return;
	
	APIFunction*	pNewFunction = new APIFunction;
	if (pNewFunction == NULL)
		return;

	pNewFunction->_RealProcAddress = (UINT32)pscFunction->_pfnOrgAddress;
	#if 1 // set to "0" for debugging...
	pNewFunction->_instr_start = 0x90; // NOP
	#else
	pNewFunction->_instr_start = 0xcc; // INT 3
	#endif
	pNewFunction->_instr_push_eax_as_retval = 0x50;
	pNewFunction->_instr_push_eax_as_flag = 0x50;
	pNewFunction->_instr_lea_eax_esp_plus_8 = 0x0824448d;
	pNewFunction->_instr_push_eax = 0x50;
	pNewFunction->_instr_push_offset_function = 0x68;
	pNewFunction->_offset_function = (UINT32)pscFunction;
	pNewFunction->_instr_call_interceptor = 0xe8;
	pNewFunction->_offset_interceptor = (UINT32)Interceptor - ((UINT32)&(pNewFunction->_offset_interceptor) + sizeof(UINT32));
	pNewFunction->_instr_pop_eax_flag = 0x58;
	pNewFunction->_instr_test_eax_eax = 0xc085;
	pNewFunction->_instr_pop_eax_retval = 0x58;
	pNewFunction->_instr_jne_plus_3 = 0x0375;
	pNewFunction->_instr_ret_pop_amount = 0xc2;
	pNewFunction->_instr_ret_amount = (UINT16)(pscFunction->_nParams * sizeof(UINT32));
	pNewFunction->_instr_jmp_dword_ptr_origaddress = 0x25ff;
	pNewFunction->_offset_origaddress = (UINT32)pNewFunction;	

	// add to API list
	LIST_INSERT(__ThunkList,pscFunction->_pfnOrgAddress,pNewFunction);

	HookDebug(" -> org=%08lx",pscFunction->_pfnOrgAddress);
}

/////////////////////////////////////////////////////////////////////////////
// get interception procedure's address if this is a hooked proc!
// (else return unmodified)
FARPROC		InterceptProc(FARPROC pfnProc)
{
	APIFunction*	pInterceptedFunction;
	
	LIST_FIND(__ThunkList,pfnProc,pInterceptedFunction);
	if (pInterceptedFunction != NULL)
		return((FARPROC)&(pInterceptedFunction->_instr_start));
	return(pfnProc);	
}

/////////////////////////////////////////////////////////////////////////////
// hooks/unhooks APIs of the module (specified by its in-memory address)
void InterceptFunctionsInModule(void* pFileBase, BOOL bHook)
{
	TCHAR	szModule[_MAX_PATH];
	
	// can we get the file's name? If not, it's no module!
	if (GetModuleFileName((HMODULE)pFileBase,szModule,sizeofTSTR(szModule)) == 0)
		return;
	HookDebug("%s:  InterceptFunctionsInModule(%08lx=%s)",__Process._szModule,pFileBase,szModule);
	
	// don't patch myself, please...
	if (pFileBase == (void*)__hInstance)
		{
		HookDebug("%s:   aborted - this is me!",__Process._szModule);
		return;
		}

	IMAGE_DOS_HEADER*	pDOSHeader = MakePtr(IMAGE_DOS_HEADER*,pFileBase,0);
	
	// is valid DOS header?
	if (IsBadReadPtr(pDOSHeader,sizeof(*pDOSHeader)))
		{
		HookDebug("%s:  InterceptFunctionsInModule(%08lx) failed: IsBadReadPtr",__Process._szModule,pFileBase);
		return;
		}
	if (pDOSHeader->e_magic != IMAGE_DOS_SIGNATURE)
		{
		HookDebug("%s:  InterceptFunctionsInModule(%08lx) failed: pDOSHeader->e_magic",__Process._szModule,pFileBase);
		return;
		}
	
	// go to NT header
	IMAGE_NT_HEADERS*	pNTHeader = MakePtr(IMAGE_NT_HEADERS*,
		pDOSHeader,
		pDOSHeader->e_lfanew);
	if (pNTHeader->Signature != IMAGE_NT_SIGNATURE)
		{
		HookDebug("%s:  InterceptFunctionsInModule(%08lx) failed: pNTHeader->Signature",__Process._szModule,pFileBase);
		return;
		}
	
	// get import descriptors
	IMAGE_IMPORT_DESCRIPTOR*	pImportDesc = MakePtr(IMAGE_IMPORT_DESCRIPTOR*,
		pFileBase,
		pNTHeader->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IMPORT].VirtualAddress);

	// no import table exists?
	if ((void*)pImportDesc == (void*)pNTHeader)
		{
		HookDebug("%s:  InterceptFunctionsInModule(%08lx) failed: no import table",__Process._szModule,pFileBase);
		return;
		}

	// iterate the imports (DLLs)...
	for (; pImportDesc->Name; ++pImportDesc)
		{
		// for each DLL, iterate the imported functions...
		IMAGE_THUNK_DATA*	pThunk = MakePtr(IMAGE_THUNK_DATA*,
			pFileBase,
			pImportDesc->FirstThunk);

	    MEMORY_BASIC_INFORMATION 	mbi;
		void*	pProtectedArea = NULL;
		UINT	nProtectedAreaSize = 0;
		DWORD	dwOldProtection;

		// if code is protected, make it read/write...		
	    if (VirtualQuery(pThunk, &mbi, sizeof(mbi)) == sizeof(mbi))
			{
			//HookDebug("    %08lx: flags %08lx",mbi.BaseAddress,mbi.Protect);
			if (!(mbi.Protect & (PAGE_READWRITE|PAGE_EXECUTE_READWRITE)))
				{
				if (VirtualProtect(
					mbi.BaseAddress,
					mbi.RegionSize,
					__bWinNT 
						? PAGE_EXECUTE_WRITECOPY
						: PAGE_READWRITE,
					&dwOldProtection))
					{
					pProtectedArea = mbi.BaseAddress;
					nProtectedAreaSize = mbi.RegionSize;
					}
				  else
				  	{
				  	HookDebug("   unable to unprotect range...");
					continue;
					}	
				}
			}
		while (pThunk->u1.Function)
			{
			if (bHook)
				{
				APIFunction*	pInterceptedFunction;
				
				LIST_FIND(__ThunkList,pThunk->u1.Function,pInterceptedFunction);
				if (pInterceptedFunction != NULL)
					{
					// is this one of the APIs to intercept?
					void*	pThunkCodeAddress = (void*)&(pInterceptedFunction->_instr_start);
					// remember old address
					LIST_INSERT(__OldAddressList,pThunkCodeAddress,pThunk->u1.Function);
					// and replace address to call by our stub
					pThunk->u1.Function = (DWORD*)pThunkCodeAddress;
					}
				}
			  else
			  	{
				// re-set to old API address
				DWORD*	pnAddress; 
				
				LIST_FIND(__OldAddressList,pThunk->u1.Function,pnAddress);

				if (pnAddress != NULL)
					pThunk->u1.Function = pnAddress;
				}	
			++pThunk;
			}

		if (nProtectedAreaSize)
			{
			DWORD	dwDummy;
			
			VirtualProtect(
				pProtectedArea,
				nProtectedAreaSize,
				dwOldProtection,
				&dwDummy);
			}
		}
}

/////////////////////////////////////////////////////////////////////////////
// hook/unhook all APIs in all available modules of this task
BOOL InterceptFunctionsInTask(BOOL bHook)
{
	HookDebug("%s:InterceptFunctionsInTask(%d)",__Process._szModule,bHook);
	
	if (bHook)
		for (int i = 0; __FunctionList[i]._nFunction != FCT_END; ++i)
			BuildAPIStub(&__FunctionList[i]);
	
    MEMORY_BASIC_INFORMATION 	mbi;
	
    for (LPBYTE lp = NULL; VirtualQuery(lp, &mbi, sizeof(mbi)) == sizeof(mbi); lp += mbi.RegionSize)
    	{
        if (mbi.State != MEM_COMMIT)
            continue;

		// HookDebug("%08lx %08lx: %08lx %08lx",mbi.BaseAddress,mbi.AllocationBase,mbi.Protect,mbi.AllocationProtect);

        if (mbi.BaseAddress != mbi.AllocationBase)	// cannot be program code if not equal
			continue;
			
		if (__bWinNT)
			{
			// PAGE_EXECUTE_WRITECOPY -> PAGE_READONLY
			if (!(mbi.Protect == PAGE_READONLY &&
				  mbi.AllocationProtect == PAGE_EXECUTE_WRITECOPY))
				continue;
			}
		  else
		  	{
			// PAGE_NOACCESS -> PAGE_READONLY
			if (!(mbi.Protect == PAGE_READONLY &&
				  mbi.AllocationProtect == PAGE_NOACCESS))
				continue;
			}

		InterceptFunctionsInModule(mbi.BaseAddress,bHook);
		}	
	HookDebug("%s:InterceptFunctionsInTask() done",__Process._szModule);
	
	if (!bHook)
		{
		// make the thunk to a "JMP [<original function>]" for each thunk, as we're not here anymore!
		// (this is needed for the GetProcAddress workaround!)
		LIST_FORALL(__ThunkList,APIIter,pNewFunction)
			{
			memcpy(&(ITER_VALUE(pNewFunction)->_instr_start),
				&(ITER_VALUE(pNewFunction)->_instr_jmp_dword_ptr_origaddress),
				sizeof(UINT16) + sizeof(UINT32));
			}
		LIST_CLEAR(__OldAddressList);
		}
	return(TRUE);	
}

