unit Rules;

interface

uses SysUtils, vc1;

const MAX_CHILDREN_PER_RULE = 50;

type
  vcAction = (vcAllow, vcDeny, vcAsk, vcUnknown);

  TRule = class;

  PVCRULE = ^vcRule;
  vcRule = record
    _name, _parentName : array[0..31] of char;
    _action : vcAction;
    _numChildren : Integer;
    _event : scEvent;
  end;

  evtMatchResult = (evtYes, evtNo, evtMaybe);

  PRule = ^TRule;
  TRule = class(TObject)
  public
    _rule : vcRule;
    _children : array[0..MAX_CHILDREN_PER_RULE] of TRule;
    constructor Create;
    function FormatEventForLog: string;
    function GetAnswer(evt: TRule; var fired: TRule): vcAction;
    function Match(evt: TRule) : evtMatchresult;
  end;

function StringFromEventType(nEvent: integer): string;
function StringFromEvent(nEvent: integer): string;

implementation

constructor TRule.Create;
begin
  inherited;
  with _rule do
  begin
    _name := '';
    _parentName := '';
    _action := vcAllow;
    _numChildren := 0;
    with _event do
    begin
      _nscEventVersion := 1;
      _nUserParam := 0;
      _szDLL := '*';
      _nEvent := 0;
      _szParameter := '*';
      with _Process do begin
        _nscProcessInfoVersion := 1;
        _nThreadID := 0;
        _szModule := '*';
        _szPath := '*';
      end;
    end;
  end;
end;

function StringFromEventType(nEvent: integer): string;
begin
  case (nEvent and VC_EVENTTYPEMASK) of
    VC_EVENTTYPE_READ: Result := 'Lesen/ffnen';
    VC_EVENTTYPE_WRITE: Result := 'Schreiben/Erzeugen';
    VC_EVENTTYPE_ENUM: Result := 'Enum';
    VC_EVENTTYPE_DELETE: Result := 'Lschen';
  else Result := 'Unbekannt';
  end;
end;

function StringFromEvent(nEvent: integer): string;
begin
  case (nEvent and VC_EVENTMASK) of
    VC_QUEST_CHECKPROCESS: Result := 'Einklinken';
    VC_EVENT_EXECUTE: Result := 'Ausfhren';
    VC_EVENT_CREATEOBJECT: Result := 'Objekterzeugung';
    VC_EVENT_CREATEFILE: Result := 'Dateierzeugung';
    VC_EVENT_FILE: Result := 'Dateizugriff';
    VC_EVENT_REGKEY: Result := 'Registry-Schlssel';
    VC_EVENT_REGVALUE: Result := 'Registry-Wert';
  else Result := 'Unbekannt';
  end;
end;

function TRule.FormatEventForLog: string;
var sEvent, sType : string;
begin; // FormatEventForLog
  with _rule._event do
  begin
    sEvent := StringFromEventType(_nEvent);
    sType := StringFromEvent(_nEvent);
    Result := Format('<%s>\<%s> via <%s>: %s(%s) - %s',
                [_Process._szPath, _Process._szModule,
                 _szDLL,
                 sType, sEvent, _szParameter]);
  end;
end;

function TRule.Match(evt: TRule) : evtMatchResult;

  function MatchStrings(s1, s2 : PChar) : evtMatchResult;
  var joker: Integer;
  begin
    if (s1 = '') or (s1 = '*') then
      Result := evtMaybe
    else
    begin
      joker := Pos('*', s1);
      if joker > 0 then
        if AnsiStrLIComp(s1, s2, joker - 1) <> 0 then
          Result := evtNo
        else
          Result := evtMaybe
      else
        if AnsiStrIComp(s1, s2) <> 0 then
          Result := evtNo
        else
          Result := evtYes
    end;
  end;

var maybe: Boolean;
begin // Match
  Result := evtYes;
  maybe := false;
  if (_rule._event._nEvent and VC_EVENTMASK) = 0 then
    maybe := true
  else if (_rule._event._nEvent and VC_EVENTMASK) <> 
          (evt._rule._event._nEvent and VC_EVENTMASK) then
    Result := evtNo
  else if (_rule._event._nEvent and VC_EVENTMASK) = VC_EVENT_FILE then
  begin
    if (_rule._event._nEvent and VC_EVENTTYPEMASK) = 0 then
      maybe := true
    else if (_rule._event._nEvent and VC_EVENTTYPEMASK) <>
            (evt._rule._event._nEvent and VC_EVENTTYPEMASK) then
      Result := evtNo;
  end;

  if Result = evtYes then
    case MatchStrings(_rule._event._Process._szModule,
                      evt._rule._event._Process._szModule) of
      evtMaybe:
        maybe := true;
      evtNo:
        Result := evtNo;
    end;

  if Result = evtYes then
    case MatchStrings(_rule._event._Process._szPath,
                      evt._rule._event._Process._szPath) of
      evtMaybe:
        maybe := true;
      evtNo:
        Result := evtNo;
    end;

  if Result = evtYes then
    case MatchStrings(_rule._event._szDLL, evt._rule._event._szDLL) of
      evtMaybe:
        maybe := true;
      evtNo:
        Result := evtNo;
    end;

  if Result = evtYes then
    case MatchStrings(_rule._event._szParameter,
                      evt._rule._event._szParameter) of
      evtMaybe:
        maybe := true;
      evtNo:
        Result := evtNo;
    end;

  if Result = evtYes then
    if maybe then
      Result := evtMaybe;
end;

function TRule.GetAnswer(evt: TRule; var fired: TRule): vcAction;
var act: vcAction;
    idx: Integer;
begin
  case Match(evt) of
    evtYes:
      begin
        fired := self;
        Result := _rule._action;
      end;
    evtNo:
      Result := vcUnknown;
    evtMaybe:
      with _rule do
      begin
        idx := 0;
        act := vcUnknown;
        while (idx < _numChildren) and (act = vcUnknown) do
        begin
          act := _children[idx].GetAnswer(evt, fired);
          Inc(idx);
        end;
        if act = vcUnknown then
        begin
          fired := self;
          Result := _action;
        end
        else
          Result := act;
      end;
    else
      Result := vcUnknown;
  end;
end;

end.
