' grafikkonverter.vbs
' Wandelt mit Corel PhotoPaint BMP-Dateien
' ins TIF- und JPG-Format um
' (C) Tobias Weltner, c't 13/2001

Set cp = CreateObject("CorelPhotoPaint.Automation.7")
Set fs = CreateObject("Scripting.FileSystemObject")
Set wshshell = CreateObject("WScript.Shell")

protokoll = ConvertAllBMPinFolder("%WINDIR%", "C:\KONVERTIERUNGEN")


wshshell.Run "notepad.exe """ & protokoll & """"
cp.SetVisible True

Function ConvertAllBMPinFolder(path, newfolder)
   Path = wshshell.ExpandEnvironmentStrings(Path)
   newfolder = wshshell.ExpandEnvironmentStrings(newfolder)
   
   ' wenn Quellordner nicht existiert, Fehler auslsen:
   If Not fs.FolderExists(Path) Then
      Err.Raise 10000, "Ordner existiert nicht", Path & " nicht gefunden!"
   End If
   
   ' wenn Zielordner nicht existiert, anlegen:
   If Not fs.FolderExists(newfolder) Then fs.CreateFolder newfolder
   
   ' Protokolldatei anlegen
   protokoll = newfolder & "\protokoll.txt"
   Set logbuch = fs.CreateTextFile(protokoll, True)
   
   ' Zugriff auf Quellordner:
   Set folder = fs.GetFolder(Path)
   
   ' alle Dateien im Ordner auflisten:
   For each file in folder.Files
      ' Dateiextension in Kleinbuchstaben:
      ext = LCase(fs.GetExtensionName(file.Name))
      
      ' ist die Datei ein BMP-Bild?
      If ext = "bmp" Then
         zielname = newfolder & "\" & fs.GetBaseName(file.Name)
         logbuch.WriteLine ConvertToTIF(file.Path, zielname & ".tif")
         logbuch.WriteLine ConvertToJPG(file.Path, zielname & ".jpg")
      End If
   Next
   
   logbuch.Close
   ConvertAllBMPinFolder = protokoll
End Function

Function ConvertToTIF(path, newpath)
   with cp
   .FileOpen Path, 0, 0, 0, 0, 0, 1, 1
   .ImageConvert 2, 1, 0, 0, 0, 0, 0, 0
   .FileSave newpath, 772, 1
   
   .FileClose
   
   ConvertToTIF = Path & " wurde nach " & newpath & " konvertiert."
End with
End Function

Function ConvertToJPG(path, newpath)
   with cp
   .FileOpen Path, 0, 0, 0, 0, 0, 1, 1
   
   If .GetDocumentType<>3 Then
      .FileSave newpath, 774, 0
      ConvertToJPG = Path & " wurde nach " & newpath & " konvertiert."
   Else
      ConvertToJPG = "WARNUNG: " & Path _
      & " konnte nicht konvertiert werden, weil es sich um ein S/W-Bild handelt!"
   End If
   .FileClose
   End with
End Function

