!!! Listing 1 (palmtest.c, Teil 1)

/* palmtest.c:  program skeleton for a PALM application
 *
 * Logic Way GmbH, 2001
 * www.logicway.de
 * Arndt Kritzner
 * kritzner@logicway.de
 *
 * version: 2001-05-07
 */

#include <PalmOS.h>
#include "palmtest.h"

#define version20		0x03500000

int AktForm;
int Beenden=0;

/***********************************************************************
 * function is called at program start
 * you can put your own initialization jobs there
 ***********************************************************************/
static UInt16 StartApplication (void)
{
	// Initialize the random number seed;
	SysRandom( TimGetSeconds() );
	return( 0 );
}

/***********************************************************************
 * function is checking ROM version of the palmos operating system
 * if ROM version is less then required the result of this function is
 * sysErrRomIncompatible
 ***********************************************************************/
static Err RomVersionCompatible (UInt32 requiredVersion, UInt16 launchFlags)
{
	UInt32 romVersion;

	// See if we're on in minimum required version of the ROM or later.
	FtrGet(sysFtrCreator, sysFtrNumROMVersion, &romVersion);
	if (romVersion < requiredVersion)
		{
		if ((launchFlags & (sysAppLaunchFlagNewGlobals | sysAppLaunchFlagUIApp)) ==
			(sysAppLaunchFlagNewGlobals | sysAppLaunchFlagUIApp))
			{
			FrmAlert (AlertROMIncompatible);

			// PalmOS before 3.5 will continuously relaunch this app unless we switch to
			// another safe one.
			AppLaunchWithCommand(sysFileCDefaultApp, sysAppLaunchCmdNormalLaunch, NULL);
			}

		return (sysErrRomIncompatible);
		}

	return (0);
}

/***********************************************************************
 * function for main form initialization
 * you can put your initialization stuff there
 * e.g. initial settings for controls and labels
 ***********************************************************************/
static void MainFormInit (FormPtr frm)
{
}

/***********************************************************************
 * handling for the main drop down menu actions
 ***********************************************************************/
static Boolean MainFormDoCommand (UInt16 command)
{
	Boolean		handled = false;

	MenuEraseStatus (0);

	switch (command)
	{
/* use this for menu action handling
		case MenuItem...:
			handled = true;
			break;
*/
	}

	return handled;
}

/***********************************************************************
 * handling for form and control actions
 * menu actions are forwarded to MainFormDoCommand
 ***********************************************************************/
static Boolean MainFormHandleEvent (EventPtr event)
{
	FormPtr frm;
	Boolean handled = false;


	if (event->eType == ctlSelectEvent)
		{
// button handling
		switch (event->data.ctlSelect.controlID)
			{
// the ok button - this leaves the application
			case BtnOk:
				Beenden = 1;
				handled = true;
				break;

			default:
				break;
			}
		}


	else if (event->eType == menuEvent)
		{
// forwarding of menu events
		return MainFormDoCommand (event->data.menu.itemID);
		}


	else if (event->eType == frmUpdateEvent)
		{
// redraws the form if needed
		FrmDrawForm (FrmGetActiveForm());
		handled = true;
		}


	else if (event->eType == frmOpenEvent)
		{
// initializes and draws the form at program launch
		frm = FrmGetActiveForm();
		MainFormInit (frm);
		FrmDrawForm (frm);
		handled = true;
		}


	else if (event->eType == frmCloseEvent)
		{
// this is done if program is closed
		}

	return (handled);
}
