Listing 2 (palmtest.c, Teil 2)

/***********************************************************************
 * chooses an displays the requested form
 ***********************************************************************/
static Boolean AppHandleEvent( EventPtr eventP)
{
	UInt16 formId;
	FormPtr frmP;


	switch (eventP->eType)
	{
	case frmLoadEvent:
// Load the form resource.
		formId = eventP->data.frmLoad.formID;
		frmP = FrmInitForm(formId);
		FrmSetActiveForm(frmP);

// Set the event handler for the form.  The handler of the currently
// active form is called by FrmHandleEvent each time is receives an
// event.
		switch (formId)
			{
			case FormINTRO:
				FrmSetEventHandler(frmP, MainFormHandleEvent);
				break;

			default:
				ErrNonFatalDisplay("Invalid Form Load Event");
				break;

			}
		break;
	default:
		return false;
	}
	return true;

}

/***********************************************************************
 * main event loop; loops until appStopEvent is caught or
 * Beenden is set
 ***********************************************************************/
static void AppEventLoop(void)
{
	UInt16 error;
	EventType event;


	do {
		EvtGetEvent(&event, evtWaitForever);


		if (! SysHandleEvent(&event))
			if (! MenuHandleEvent(0, &event, &error))
				if (! AppHandleEvent(&event))
					FrmDispatchEvent(&event);

// Check the heaps after each event
		#if EMULATION_LEVEL != EMULATION_NONE
			MemHeapCheck(0);
			MemHeapCheck(1);
		#endif

	} while ((event.eType != appStopEvent) && (! Beenden));

}

/***********************************************************************
 * application is finished, so we have to clean the desktop behind us
 ***********************************************************************/
static void StopApplication (void)
{
	FrmCloseAllForms ();
}

/***********************************************************************
 * main function
 ***********************************************************************/
UInt32 PilotMain(UInt16 cmd, MemPtr cmdPBP, UInt16 launchFlags)
{
	UInt16 error;
	error = RomVersionCompatible (version20, launchFlags);
	if (error) return (error);


	if ( cmd == sysAppLaunchCmdNormalLaunch )
	{
		error = StartApplication ();
		if (error) return (error);

		FrmGotoForm (FormINTRO);

		AppEventLoop ();
		StopApplication ();
	}
	return 0;
}