' ****************************************************************
' Funktion:      Kopiert gedroppte Dateien und Ordner in einen
'                (freigegebenen Netzwerk-) Ordner.
'
' Erfordert:    - Windows Scripting Host 2.0
'               - Desktop-Erweiterungen des IE ab Version 4.0
'
' Copyright (C) 2001 Ralf Nebelo
' ****************************************************************

Option Explicit

Dim objFS
Dim objShellApp
Dim strZielOrdner
Dim objFolder
Dim strPathName
Dim objItem
Dim intI


On Error Resume Next

Set objFS = WScript.CreateObject("Scripting.FileSystemObject")
Set objShellApp = CreateObject("Shell.Application")

If Wscript.Arguments.Count = 0 Then
    MsgBox "Keine Dateien oder Ordner gedroppt.", vbInformation, Wscript.ScriptName
    WScript.Quit
End If

'Pfad des Zielordners nach eigenem Bedarf anpassen
strZielOrdner = "\\Henkelmann\C\WINDOWS\Desktop"

Set objFolder = objShellApp.NameSpace(strZielOrdner)
If objFolder Is Nothing Then
    MsgBox "Der Zielordner ist nicht verfgbar.", vbCritical, Wscript.ScriptName
    WScript.Quit
End If 
 
For intI = 0 To Wscript.Arguments.Count - 1
    strPathName = Wscript.Arguments(intI)
    If objFS.FolderExists(strPathName) = True Then
        Set objItem = objFS.GetFolder(strPathName)
    ElseIf objFS.FileExists(strPathName) = True Then
        Set objItem = objFS.GetFile(strPathName)
    End If
    
    objFolder.CopyHere objItem.Path
Next
