VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cASPI"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'*************************************
'**  uCDDB - CDDB Active-X Control  **
'**   (c) 2001 by Jon Zahornacky    **
'*************************************
'
'(c) Jon F. Zahornacky - 2001
' E-mail: jonzeke@yahoo.com
'
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 2.1 of the License, or (at your option) any later version.
'
'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
'Lesser General Public License for more details.
'
'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
'
' CDDB Control Module
' - I/O to FreeCDDB to get CDDB info
'
'''''''''''''''''''''''''''''''''''''''

Option Explicit

'defines

'ASPI Commands
Private Const SC_HA_INQUIRY = &H0        'Host adapter inquiry
Private Const SC_GET_DEV_TYPE = &H1      'Get device type
Private Const SC_EXEC_SCSI_CMD = &H2     'Execute SCSI command
Private Const SC_ABORT_SRB = &H3         'Abort an SRB
Private Const SC_RESET_DEV = &H4         'SCSI bus device reset
Private Const SC_SET_HA_PARMS = &H5      'Set HA parameters
Private Const SC_GET_DISK_INFO = &H6     'Get Disk
Private Const SC_RESCAN_SCSI_BUS = &H7   'Rebuild SCSI device map
Private Const SC_GETSET_TIMEOUTS = &H8   'Get/Set target timeouts

'ASPI SRB Status
Private Const SS_PENDING = &H0           'SRB being processed
Private Const SS_COMP = &H1              'SRB completed without error
Private Const SS_ABORTED = &H2           'SRB aborted                    */
Private Const SS_ABORT_FAIL = &H3        'Unable to abort SRB
Private Const SS_ERR = &H4               'SRB completed with error
Private Const SS_INVALID_CMD = &H80      'Invalid ASPI command
Private Const SS_INVALID_HA = &H81       'Invalid host adapter number
Private Const SS_NO_DEVICE = &H82        'SCSI device not installed
Private Const SS_INVALID_SRB = &HE0      'Invalid parameter set in SRB
Private Const SS_OLD_MANAGER = &HE1      'ASPI manager doesn't support windows
Private Const SS_BUFFER_ALIGN = &HE1     'Buffer not aligned (SS_OLD_MANAGER in Win32)
Private Const SS_ILLEGAL_MODE = &HE2     'Unsupported Windows mode
Private Const SS_NO_ASPI = &HE3          'No ASPI managers
Private Const SS_FAILED_INIT = &HE4      'ASPI for windows failed init
Private Const SS_ASPI_IS_BUSY = &HE5     'No resources available to execute command
Private Const SS_BUFFER_TOO_BIG = &HE6   'Buffer size too big to handle
Private Const SS_MISMATCH_FILES = &HE7   'The DLLs/EXEs of ASPI don't version check
Private Const SS_NO_ADAPTERS = &HE8      'No host adapters located
Private Const SS_SHORT_RESOURCES = &HE9  'Couldn't allocate resources  needed to init
Private Const SS_ASPI_IS_SHUTDOWN = &HEA 'Call came to ASPI after PROCESS_DETACH
Private Const SS_BAD_INSTALL = &HEB      'The DLL or other components are installed wrong

'SRB - COMMAND HEADER COMMON
Private Type SRB
    SRB_Cmd As Byte             '00h/00 ASPI command code
    SRB_Status As Byte          '01h/01 ASPI command status byte
    SRB_HaID As Byte            '02h/02 ASPI host adapter number
    SRB_Flags As Byte           '03h/03 ASPI request flags
    SRB_Hdr_Rsvd As Long        '04h/04 Reserved, must = 0
End Type

'SRB - HOST ADAPTER INQUIRIY - SC_HA_INQUIRY (0)
Private Type SRB_HAInquiry
    SRB_Cmd As Byte             '00h/00 ASPI command code == SC_HA_INQUIRY
    SRB_Status As Byte          '01h/01 ASPI command status byte
    SRB_HaID As Byte            '02h/02 ASPI host adapter number
    SRB_Flags As Byte           '03h/03 ASPI request flags
    SRB_Hdr_Rsvd As Long        '04h/04 Reserved, must = 0
    HA_Count As Byte            '08h/08 Number of host adapters present
    HA_Id As Byte               '09h/09 SCSI ID of host adapter
    HA_MgrId As String * 16     '0ah/10 String describing the manager
    HA_Ident As String * 16     '1ah/26 String describing the host adapter
    HA_Unique(15) As Byte       '2ah/42 Host Adapter Unique parameters
    HA_Rsvd As Integer          '3ah/58 Reserved, must = 0
    HA_Pad(19) As Byte          '3eh/62 padding
End Type

'SRB - GET DEVICE TYPE - SC_GET_DEV_TYPE (1)
Private Type SRB_GetDevType
    SRB_Cmd As Byte             '00h/00 ASPI command code == SC_HA_INQUIRY
    SRB_Status As Byte          '01h/01 ASPI command status byte
    SRB_HaID As Byte            '02h/02 ASPI host adapter number
    SRB_Flags As Byte           '03h/03 ASPI request flags
    SRB_Hdr_Rsvd As Long        '04h/04 Reserved, must = 0
    SRB_Target As Byte          '08h/08 Target's SCSI ID
    SRB_Lun As Byte             '09h/09 Target's LUN number
    DEV_DeviceType As Byte      '0ah/10 Target's peripheral device type
    DEV_Rsvd1 As Byte           '0bh/11 Reserved, must = 0
    DEV_Pad(67) As Byte         '0ch/12 padding
End Type

'SRB - EXECUTE SCSI COMMAND - SC_EXEC_SCSI_CMD (2)
Private Type SRB_ExecuteIO
    SRB_Cmd As Byte             '00h/00 ASPI command code == SC_HA_INQUIRY
    SRB_Status As Byte          '01h/01 ASPI command status byte
    SRB_HaID As Byte            '02h/02 ASPI host adapter number
    SRB_Flags As Byte           '03h/03 ASPI request flags
    SRB_Hdr_Rsvd As Long        '04h/04 Reserved, must = 0
    SRB_Target As Byte          '08h/08 Target's SCSI ID
    SRB_Lun As Byte             '09h/09 Target's LUN number
    SRB_Rsvd1 As Integer        '0ah/10 Reserved for alignment
    SRB_BufLen As Long          '0ch/12 Data Allocation Length
    SRB_BufPointer As Long      '10h/16 Data Buffer Pointer
    SRB_SenseLen As Byte        '14h/20 Sense Allocation Length
    SRB_CDBLen As Byte          '15h/21 CDB Length
    SRB_HaStat As Byte          '16h/22 Host Adapter Status
    SRB_TargStat As Byte        '17h/23 Target Status
    SRB_PostProc As Long        '18h/24 Post routine
    SRB_Rsvd2(19) As Byte       '1ch/28 Reserved, must = 0
    SRB_CDBByte(15) As Byte     '30h/48 SCSI CDB
    SRB_SenseData(15) As Byte   '40h/64 Request Sense buffer
End Type

'PERIPHERAL DEVICE TYPE DEFINITIONS
Private Const DTYPE_DASD = 0         'Disk Device
Private Const DTYPE_SEQD = 1         'Tape Device
Private Const DTYPE_PRNT = 2         'Printer
Private Const DTYPE_PROC = 3         'Processor
Private Const DTYPE_WORM = 4         'Write-once read-multiple
Private Const DTYPE_CROM = 5         'CD-ROM device
Private Const DTYPE_CDROM = 5        'CD-ROM device
Private Const DTYPE_SCAN = 6         'Scanner device
Private Const DTYPE_OPTI = 7         'Optical memory device
Private Const DTYPE_JUKE = 8         'Medium Changer device
Private Const DTYPE_COMM = 9         'Communications device
Private Const DTYPE_RESL = &HA       'Reserved (low)
Private Const DTYPE_RESH = &H1E      'Reserved (high)
Private Const DTYPE_UNKNOWN = &H1F   'Unknown or no device type

'Misc constants used by SCSI I/O commands
Private Const SENSE_LEN = 14         'Default sense buffer length.
Private Const SRB_DIR_IN = &H8       'Transfer from SCSI target to host.
Private Const SRB_DIR_OUT = &H10     'Transfer from host to SCSI target.
Private Const SRB_POSTING = &H1      'Enable ASPI posting.
Private Const SRB_EVENT_NOTIFY = &H40    'Enable ASPI event notification.
Private Const SRB_ENABLE_RESIDUAL = &H4  'Enable residual byte count reporting.

'Host Adapter Status Values
Private Const HASTAT_OK = &H0            'Host adapter did not detect an error.
Private Const HASTAT_TIMEOUT = &H9       'Timed out while SRB was waiting to be processed.
Private Const HASTAT_CMD_TIMEOUT = &HB   'While processing the SRB, adapter timed out.
Private Const HASTAT_MSG_REJECT = &HD    'While processing SRB, the adapter received a MESSAGE REJECT.
Private Const HASTAT_BUS_RESET = &HE     'A bus reset was detected.
Private Const HASTAT_PARITY_ERROR = &HF  'A parity error was detected.
Private Const HASTAT_REQ_SENSE_FAIL = &H10 'The adapter failed in issuing REQUEST SENSE.
Private Const HASTAT_SEL_TO = &H11       'Selection Timeout.
Private Const HASTAT_DO_DU = &H12        'Data overrun / data underrun.
Private Const HASTAT_BUS_FREE = &H13     'Unexpected bus free.
Private Const HASTAT_PHASE_ERR = &H14    'Target bus phase sequence failure.

'Target Status Values
Private Const STATUS_GOOD = &H0          'Status Good.
Private Const STATUS_CHKCOND = &H2       'Check Condition.
Private Const STATUS_CONDMET = &H4       'Condition Met.
Private Const STATUS_BUSY = &H8          'Busy.
Private Const STATUS_INTERM = &H10       'Intermediate.
Private Const STATUS_INTCDMET = &H14     'Intermediate-condition met.
Private Const STATUS_RESCONF = &H18      'Reservation conflict.
Private Const STATUS_CMD_TERM = &H22     'Command Terminated.
Private Const STATUS_QFULL = &H28        'Queue full.

'Sense Codes
Private Const SENSE_CURRENT = &H70       'Sense data is from current command.
Private Const SENSE_DEFFERED = &H71      'Sense data is from a previous command.

'Sense Key Values
Private Const KEY_NOSENSE = &H0          'No Sense.
Private Const KEY_RECERROR = &H1         'Recovered Error.
Private Const KEY_NOTREADY = &H2         'Not Ready.
Private Const KEY_MEDIUMERROR = &H3      'Medium Error.
Private Const KEY_HARDERROR = &H4        'Hardware Error.
Private Const KEY_ILLGLREQ = &H5         'Illegal Request.
Private Const KEY_UNITATT = &H6          'Unit Attention.
Private Const KEY_DATAPROT = &H7         'Data Protection.
Private Const KEY_BLANKCHK = &H8         'Blank Check.
Private Const KEY_VENDSPEC = &H9         'Vendor Specific.
Private Const KEY_COPYABORT = &HA        'Copy Aborted.
Private Const KEY_ABORTCMD = &HB         'Aborted Command.
Private Const KEY_EQUAL = &HC            'Equal (Search).
Private Const KEY_VOLOVRFLW = &HD        'Volume Overflow.
Private Const KEY_MISCOMP = &HE          'Miscompare (Search).
Private Const KEY_RSVD = &HF             'Reserved.

'SCSI Commands for all Device Types
Private Const SCSI_TST_U_RDY = &H0       'Test Unit Ready (Mandatory)
Private Const SCSI_REQ_SENSE = &H3       'Request Sense (Mandatory)
Private Const SCSI_READ = &H8            'Read (Mandatory)
Private Const SCSI_WRITE = &HA           'Write (Mandatory)
Private Const SCSI_INQUIRY = &H12        'Inquiry (Mandatory)
Private Const SCSI_MODE_SEL6 = &H15      'Mode Select 6-byte (Device Specific)
Private Const SCSI_MODE_SEN6 = &H1A      'Mode Sense 6-byte (Device Specific)
Private Const SCSI_MODE_SEL10 = &H55     'Mode Select 10-byte (Device Specific)
Private Const SCSI_MODE_SEN10 = &H5A     'Mode Sense 10-byte (Device Specific)

'ASPI DLL Declarations - using the ASPIshim.DLL
Private Declare Function CheckASP32Initialized Lib "ASPIshim" _
    Alias "CheckASP32InitializedEx" () As Boolean

Private Declare Function GetASPI32SupportInfo Lib "ASPIshim" _
    Alias "GetASPI32SupportInfoEx" () As Long

Private Declare Function SendASPI32Inquiry Lib "ASPIshim" _
    Alias "SendASPI32CommandEx" (hSRB As SRB_HAInquiry) As Long

Private Declare Function SendASPI32DevType Lib "ASPIshim" _
    Alias "SendASPI32CommandEx" (hSRB As SRB_GetDevType) As Long

Private Declare Function SendASPI32ExecIO Lib "ASPIshim" _
    Alias "SendASPI32CommandEx" (hSRB As SRB_ExecuteIO) As Long

'local storage
Private m_TOC As String
Private m_W2k As Boolean
'

'****************
'** Properties **
'****************
Public Property Get GetTOC() As String

    GetTOC = m_TOC
End Property

'*****************************
'** Main processing routine **
'*****************************
Public Function InitMediaToc(ByVal strDrive) As Boolean
    Dim nRet As Long, i As Integer, iCMP As Integer
    Dim iHA As Integer, iCD As Integer, iLU As Integer
    Dim numAdapters As Integer, sts As Integer
    Dim Inquiry As SRB_HAInquiry
    Dim DevType As SRB_GetDevType
    Dim ExecIO As SRB_ExecuteIO
    Dim oCD As New cMCI, tmpTOC As String
    Dim TocBuffer As TOC
    Dim mins As Long, secs As Long, frms As Long
    Dim trks As Integer, offst As Long, s As String

    'process errors here
    On Error GoTo errChk

    'see if ASPI is supported
    If (CheckASP32Initialized() = False) Then GoTo errChk

    'try to read with MCI interface
    If (oCD.InitMediaToc(strDrive)) Then
        tmpTOC = oCD.GetTOC
        Set oCD = Nothing
    End If

    'detect adapters
    nRet = GetASPI32SupportInfo()
    sts = nRet / 256
    If (sts = SS_COMP) Then numAdapters = nRet And &HF

    'scan adapters for CDROMS
    For iHA = 0 To numAdapters
        'see if adapter responds...
        Inquiry.SRB_Cmd = SC_HA_INQUIRY
        Inquiry.SRB_HaID = iHA
        Inquiry.SRB_Flags = 0
        Inquiry.SRB_Hdr_Rsvd = 0
        nRet = SendASPI32Inquiry(Inquiry)
        If (Inquiry.SRB_Status <> SS_COMP) Then GoTo skipAdapter

        'OK, scan for CDROM's
        For iCD = 0 To 7
          For iLU = 0 To 1
            'scan dev types
            DevType.SRB_Cmd = SC_GET_DEV_TYPE
            DevType.SRB_HaID = iHA
            DevType.SRB_Flags = 0
            DevType.SRB_Hdr_Rsvd = 0
    
            DevType.SRB_Target = iCD
            DevType.SRB_Lun = iLU
                
            nRet = SendASPI32DevType(DevType)
            If (DevType.SRB_Status <> SS_COMP) Then GoTo skipDevice

            'got a CDROM, get the TOC
            If (DevType.DEV_DeviceType = DTYPE_CDROM) Then
                ExecIO.SRB_Cmd = SC_EXEC_SCSI_CMD
                ExecIO.SRB_HaID = iHA
                ExecIO.SRB_Flags = SRB_DIR_IN
                ExecIO.SRB_Hdr_Rsvd = 0

                ExecIO.SRB_Target = iCD
                ExecIO.SRB_Lun = iLU
                ExecIO.SRB_SenseLen = 14

                ExecIO.SRB_BufLen = &H324
                ExecIO.SRB_BufPointer = VarPtr(TocBuffer)

                ExecIO.SRB_CDBLen = &HA
                ExecIO.SRB_CDBByte(0) = &H43    'read TOC command
                ExecIO.SRB_CDBByte(1) = &H2     'MSF mode
                ExecIO.SRB_CDBByte(7) = &H3     'high-order byte of buffer len
                ExecIO.SRB_CDBByte(8) = &H24    'low-order byte of buffer len

                nRet = SendASPI32ExecIO(ExecIO)
                While ExecIO.SRB_Status = SS_PENDING
                    DoEvents
                Wend
                If (ExecIO.SRB_Status <> SS_COMP) Then GoTo skipDevice

                'check if valid TOC present...
                trks = TocBuffer.LastTrack - TocBuffer.FirstTrack + 1
                If (TocBuffer.LastTrack = 0 And TocBuffer.FirstTrack = 0) Or _
                   (trks < 1) Then Exit Function

               'compute running offsets / verify an audio CD
                sts = 0: s = ""
                For i = 0 To trks
                    mins = TocBuffer.TocTrack(i).Addr(1)
                    secs = TocBuffer.TocTrack(i).Addr(2)
                    frms = TocBuffer.TocTrack(i).Addr(3)
                    
                    offst = (mins * 60 * 75) + (secs * 75) + frms
                    s = s & " " & Format$(offst)
                    
                    'FLAG if audio track found
                    If (TocBuffer.TocTrack(i).ADR = &H10) Then sts = 1
                Next i

                'failed if no audio tracks...
                If (sts = 0) Then Exit Function

                'check for match with MCI TOC and ASPI TOC
                'this allows us to correlate ASPI ID to Drive Letter
                'the MCI toc will be shorter, so back off one entry
                'to remove the lead-out(will be wrong if CD-EXTRA),
                'and we should compare OK to that point
                ' Concept courtesy of Joerg at freedb.org :)
                For iCMP = Len(tmpTOC) To 1 Step -1
                    If InStr(iCMP, tmpTOC, " ", vbTextCompare) Then Exit For
                Next
                
                m_TOC = Trim$(s)
                If (Left$(tmpTOC, iCMP - 1) = Left$(m_TOC, iCMP - 1)) Then GoTo tocFound
            End If
skipDevice:
          Next iLU
        Next iCD
skipAdapter:
    Next iHA

errChk:
    InitMediaToc = False
    Exit Function
    
tocFound:
    'good TOC
    m_TOC = Trim$(s)
    InitMediaToc = True
End Function

