Set fs = CreateObject("Scripting.FileSystemObject")
Set dict = CreateObject("Scripting.Dictionary")

bildarchiv = "C:\Eigene Dateien\Eigene Bilder\Desktop"
desktop = "C:\Windows\Desktop"
extension = "jpg"
default = "Desktop.jpg"

If Not fs.FolderExists(bildarchiv) Then
  ' Ordner existiert nicht
  MsgBox "Ordner " & bildarchiv & " existiert nicht!", vbExclamation
  WScript.Quit
End If

' alle Dateien im Ordner untersuchen
cc = 0
Set hintergrund = fs.GetFolder(bildarchiv).files

For Each file In hintergrund
  ' Dateityp ermitteln
  ext = lcase(fs.GetExtensionName(file.name))
  ' ist es ein JPG-Bild?
  If ext = extension Then
    ' ja, ins Dictionary einfgen
    dict.Add cc, file.path
    cc = cc + 1
  End If
Next

If cc > 0 Then
  ' eins der gesammelten Bilder aussuchen:
  Randomize
  zufall = Fix(Rnd * dict.Count)

  ' Bild aktivieren
  fs.copyfile dict(zufall), desktop & "\" & default
Else
  MsgBox "Keine " & ucase(extension) & "-Bilder im Ordner " & bildarchiv
End If
