VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cMCI"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'*************************************
'**  uCDDB - CDDB Active-X Control  **
'**   (c) 2001 by Jon Zahornacky    **
'*************************************
'
'(c) Jon F. Zahornacky - 2001
' E-mail: jonzeke@yahoo.com
'
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 2.1 of the License, or (at your option) any later version.
'
'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
'Lesser General Public License for more details.
'
'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
'
' CDDB Control Module
' - I/O to FreeCDDB to get CDDB info
'
'''''''''''''''''''''''''''''''''''''''

Option Explicit

'defines
Private Const MCI_OPEN = &H803
Private Const MCI_CLOSE = &H804
Private Const MCI_FORMAT_MSF = 2
Private Const MCI_OPEN_ELEMENT = &H200&
Private Const MCI_OPEN_TYPE = &H2000&
Private Const MCI_SET = &H80D
Private Const MCI_SET_TIME_FORMAT = &H400&

Private Const MCI_STATUS = &H814
Private Const MCI_STATUS_ITEM = &H100&
Private Const MCI_STATUS_LENGTH = &H1&
Private Const MCI_STATUS_NUMBER_OF_TRACKS = &H3&
Private Const MCI_STATUS_POSITION = &H2&
Private Const MCI_TRACK = &H10&

Private Type MCI_OPEN_PARMS
    dwCallback As Long
    wDeviceID As Long
    lpstrDeviceType As String
    lpstrElementName As String
    lpstrAlias As String
End Type

Private Type MCI_SET_PARMS
    dwCallback As Long
    dwTimeFormat As Long
    dwAudio As Long
End Type

Private Type MCI_STATUS_PARMS
    dwCallback As Long
    dwReturn As Long
    dwItem As Long
    dwTrack As Integer
End Type

'API's
Private Declare Function mciSendCommand Lib "winmm.dll" _
    Alias "mciSendCommandA" _
    (ByVal wDeviceID As Long, ByVal uMessage As Long, _
     ByVal dwParam1 As Long, ByRef dwParam2 As Any) As Long

Private Declare Function mciGetErrorString Lib "winmm.dll" _
    Alias "mciSendCommandA" _
    (ByVal fdwError As Long, ByRef lpszErrorText As String, _
     ByVal cchErrorText As Integer)

'local storage
Private mciOpenParms As MCI_OPEN_PARMS
Private mciSetParms As MCI_SET_PARMS
Private mciStatusParms As MCI_STATUS_PARMS

Private m_TOC   As String
Private m_DevID As Long
'

'****************
'** Properties **
'****************
Public Property Get GetTOC() As String

    GetTOC = m_TOC
End Property

'*****************************
'** Main processing routine **
'*****************************
Public Function InitMediaToc(ByVal strDrive As String) As Boolean

    'construct TOC
    If (VerifyCD(strDrive) = True) Then
        If (OpenCD(strDrive) = True) Then
            'get TOC
            InitMediaToc = ReadTOC
            CloseCD
            Exit Function
        End If
    End If

    InitMediaToc = False
End Function

'**********************************************
'** Check for CD-Rom and Audio Disk in drive **
'**********************************************
Private Function VerifyCD(ByVal strDrive As String) As Boolean
    Dim fso As FileSystemObject
    Dim fsoDrive As Drive

    'process errors
    On Error GoTo errChk

    'file system object
    Set fso = New FileSystemObject

    'Make sure the drive exists
    If (fso.DriveExists(strDrive) = False) Then GoTo errChk

    'get drive object
    Set fsoDrive = fso.GetDrive(strDrive)
    strDrive = fsoDrive.Path

    'Make sure the drive is a CD drive
    If (fso.GetDrive(strDrive).DriveType <> CDRom) Then GoTo errChk
    
    'Make sure there is a CD in the drive
    If (fso.GetDrive(strDrive).IsReady = False) Then GoTo errChk
    
    '****************************************************************
    ' Allow MCI to read the CD-Extra media (aspi module needs it).
    ' This could be a conditional path, if you want to be purist.
    ' Per Joerg at Freedb.org, this is OK; even if it sometimes
    '  allows CD-Extra to submit an incomplete(fuzzy) TOC packet.
    '****************************************************************
    'Make sure we have an audio CD in the drive
    'If (fso.FileExists(fso.BuildPath(strDrive, "track01.cda")) = False) Then GoTo errChk
    '****************************************************************

    Set fso = Nothing
    Set fsoDrive = Nothing
    
    'good device
    VerifyCD = True
    Exit Function
    
errChk:
    Set fso = Nothing
    Set fsoDrive = Nothing
    
    'good device
    VerifyCD = False
End Function

'*************************************
'** Open CD-rom using MCI interface **
'*************************************
Private Function OpenCD(ByVal strDrive As String) As Boolean
    Dim idx As Integer
    Dim sts As Long

    'process errors
    On Error GoTo errChk

    'Attempt to open the CD device
    mciOpenParms.lpstrDeviceType = "cdaudio"
    mciOpenParms.lpstrElementName = strDrive
    sts = mciSendCommand(0, MCI_OPEN, (MCI_OPEN_TYPE Or MCI_OPEN_ELEMENT), mciOpenParms)
    If (sts <> 0) Then GoTo errChk

    'set id for later closure
    m_DevID = mciOpenParms.wDeviceID
    
    'Setup device for reading
    mciSetParms.dwTimeFormat = MCI_FORMAT_MSF
    sts = mciSendCommand(m_DevID, MCI_SET, MCI_SET_TIME_FORMAT, mciSetParms)
    If (sts <> 0) Then GoTo errChk
    
    'good OPEN
    OpenCD = True
    Exit Function

errChk:
    OpenCD = False
End Function

'**********************************************
'** Read in Track info, and generate the TOC **
'**********************************************
Private Function ReadTOC() As Boolean
    Dim idx As Integer, trks As Integer
    Dim mins As Long, secs As Long, frms As Long
    Dim sts As Long, offst As Long, s As String

    'process errors here
    On Error GoTo errChk
   
    'get number of tracks on CD
    mciStatusParms.dwItem = MCI_STATUS_NUMBER_OF_TRACKS
    sts = mciSendCommand(m_DevID, MCI_STATUS, MCI_STATUS_ITEM, mciStatusParms)
    If (sts <> 0) Then GoTo errChk
    trks = mciStatusParms.dwReturn

    'now get position of each track start...
    For idx = 1 To trks
        mciStatusParms.dwItem = MCI_STATUS_POSITION
        mciStatusParms.dwTrack = idx
        sts = mciSendCommand(m_DevID, MCI_STATUS, MCI_STATUS_ITEM Or MCI_TRACK, mciStatusParms)
        If (sts <> 0) Then GoTo errChk

        'compute running offsets
        mins = (mciStatusParms.dwReturn) And &HFF
        secs = (mciStatusParms.dwReturn \ 256) And &HFF
        frms = (mciStatusParms.dwReturn \ 65536) And &HFF
        
        offst = (mins * 60 * 75) + (secs * 75) + frms
        s = s & " " & Format$(offst)
    Next idx

    'now compute leadout offset...
    mciStatusParms.dwItem = MCI_STATUS_LENGTH
    mciStatusParms.dwTrack = trks
    sts = mciSendCommand(m_DevID, MCI_STATUS, MCI_STATUS_ITEM Or MCI_TRACK, mciStatusParms)
    If (sts <> 0) Then GoTo errChk

    'get len of last track
    mins = (mciStatusParms.dwReturn) And &HFF
    secs = (mciStatusParms.dwReturn \ 256) And &HFF
    frms = ((mciStatusParms.dwReturn \ 65536) And &HFF) + 1
    
    'and add to start of last track
    offst = offst + (mins * 60 * 75) + (secs * 75) + frms
    s = s & " " & Format$(offst)

    m_TOC = Trim$(s)
    ReadTOC = True
    Exit Function

errChk:
    ReadTOC = False
End Function

'**************************
'** Close the MCI device **
'**************************
Private Sub CloseCD()
    Dim sts As Long

    sts = mciSendCommand(m_DevID, MCI_CLOSE, 0, 0)
End Sub

