Attribute VB_Name = "mDefines"
'***************************************
'**  uFREEDB - CDDB Active-X Control  **
'**    (c) 2001 by Jon Zahornacky     **
'***************************************
'
'(c) Jon F. Zahornacky - 2001
' E-mail: jonzeke@yahoo.com
'
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 2.1 of the License, or (at your option) any later version.
'
'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
'Lesser General Public License for more details.
'
'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
'
' FREEDB Control Module
' - I/O to FreeCDDB to get CDDB info
'
'''''''''''''''''''''''''''''''''''''''

Option Explicit

'// Inet service flags
Public Const INTERNET_SERVICE_HTTP = 3

'// Inet port numbers
Public Const INTERNET_DEFAULT_HTTP_PORT = 80
Public Const INTERNET_DEFAULT_HTTPS_PORT = 443
Public Const INTERNET_DEFAULT_SOCKS_PORT = 1080

'// InternetOpen modes
Public Const INTERNET_OPEN_TYPE_PRECONFIG = 0
Public Const INTERNET_OPEN_TYPE_DIRECT = 1
Public Const INTERNET_OPEN_TYPE_PROXY = 3

'// Inet option flags
Public Const INTERNET_OPTION_CONNECT_TIMEOUT = 2
Public Const INTERNET_OPTION_RECEIVE_TIMEOUT = 6
Public Const INTERNET_OPTION_SEND_TIMEOUT = 5
Public Const INTERNET_OPTION_USERNAME = 28
Public Const INTERNET_OPTION_PASSWORD = 29
Public Const INTERNET_OPTION_PROXY_USERNAME = 43
Public Const INTERNET_OPTION_PROXY_PASSWORD = 44

'// Operation flags
Public Const INTERNET_FLAG_NO_AUTH = &H40000
Public Const INTERNET_FLAG_KEEP_CONNECTION = &H400000
Public Const INTERNET_FLAG_RELOAD = &H80000000

'// Values for the InfoLevel argument
Public Const HTTP_QUERY_CONTENT_TYPE = 1
Public Const HTTP_QUERY_CONTENT_LENGTH = 5
Public Const HTTP_QUERY_EXPIRES = 10
Public Const HTTP_QUERY_LAST_MODIFIED = 11
Public Const HTTP_QUERY_PRAGMA = 17
Public Const HTTP_QUERY_VERSION = 18
Public Const HTTP_QUERY_STATUS_CODE = 19
Public Const HTTP_QUERY_STATUS_TEXT = 20
Public Const HTTP_QUERY_RAW_HEADERS = 21
Public Const HTTP_QUERY_RAW_HEADERS_CRLF = 22
Public Const HTTP_QUERY_FORWARDED = 30
Public Const HTTP_QUERY_SERVER = 37
Public Const HTTP_QUERY_USER_AGENT = 39
Public Const HTTP_QUERY_SET_COOKIE = 43
Public Const HTTP_QUERY_REQUEST_METHOD = 45
Public Const HTTP_STATUS_DENIED = 401
Public Const HTTP_STATUS_PROXY_AUTH_REQ = 407

'// HTPP query flags
Public Const HTTP_QUERY_FLAG_REQUEST_HEADERS = &H80000000
Public Const HTTP_QUERY_FLAG_NUMBER = &H20000000

'// HTTP header mode flags
Public Const HTTP_ADDREQ_FLAG_ADD_IF_NEW = &H10000000
Public Const HTTP_ADDREQ_FLAG_ADD = &H20000000
Public Const HTTP_ADDREQ_FLAG_REPLACE = &H80000000

'// Returns the version number of Wininet.dll.
Public Const INTERNET_OPTION_VERSION = 40

Public Type tWinInetDLLVersion
    lMajorVersion As Long
    lMinorVersion As Long
End Type

'declares
Public Declare Function InternetOpen Lib "wininet.dll" _
    Alias "InternetOpenA" _
    (ByVal sCallerName As String, ByVal lAccessType As Long, _
     ByVal sProxyName As String, ByVal sProxyBypass As String, _
     ByVal lFlags As Long) As Long

Public Declare Function InternetConnect Lib "wininet.dll" _
    Alias "InternetConnectA" _
    (ByVal hInternetSession As Long, ByVal sServerName As String, _
     ByVal nServerPort As Integer, ByVal sUsername As String, _
     ByVal sPassword As String, ByVal lService As Long, _
     ByVal lFlags As Long, ByVal lContext As Long) As Long

Public Declare Function InternetOpenUrl Lib "wininet.dll" _
    Alias "InternetOpenUrlA" _
    (ByVal hInternetSession As Long, ByVal sUrl As String, _
     ByVal sHeaders As String, ByVal lLength As Long, _
     ByVal lFlags As Long, ByVal lContext As Long) As Long

Public Declare Function HttpOpenRequest Lib "wininet.dll" _
    Alias "HttpOpenRequestA" _
    (ByVal hInternetSession As Long, ByVal sVerb As String, _
     ByVal sObjectName As String, ByVal sVersion As String, _
     ByVal sReferer As String, ByVal lAcceptTypes As Long, _
     ByVal lFlags As Long, ByVal lContext As Long) As Long

Public Declare Function HttpAddRequestHeaders Lib "wininet.dll" _
    Alias "HttpAddRequestHeadersA" _
    (ByVal hHttpRequest As Long, ByVal sHeaders As String, _
     ByVal lHeadersLength As Long, ByVal lModifiers As Long) As Integer

Public Declare Function HttpSendRequest Lib "wininet.dll" _
    Alias "HttpSendRequestA" _
    (ByVal hHttpRequest As Long, _
     ByVal sHeaders As String, ByVal lHeadersLength As Long, _
     ByVal sOptional As String, ByVal lOptionalLength As Long) As Boolean

Public Declare Function InternetQueryOption Lib "wininet.dll" _
    Alias "InternetQueryOptionA" _
    (ByVal hInternetHandle As Long, ByVal lOption As Long, _
     ByRef sBuffer As Any, ByRef lBufferLength As Long) As Integer

Public Declare Function InternetSetOption Lib "wininet.dll" _
    Alias "InternetSetOptionA" _
    (ByVal hInternetHandle As Long, ByVal lOption As Long, _
     ByRef sBuffer As Any, ByVal lBufferLength As Long) As Long

Public Declare Function HttpQueryInfo Lib "wininet.dll" _
    Alias "HttpQueryInfoA" _
    (ByVal hHttpRequest As Long, _
     ByVal lInfoLevel As Long, _
     ByVal sBuffer As Any, ByRef lBufferLength As Long, _
     ByRef lIndex As Long) As Boolean

Public Declare Function InternetReadFile Lib "wininet.dll" _
    (ByVal hFile As Long, ByVal sBuffer As String, _
     ByVal lNumBytesToRead As Long, lNumberOfBytesRead As Long) As Integer

Public Declare Function InternetWriteFile Lib "wininet.dll" _
    (ByVal hFile As Long, ByRef sBuffer As String, _
     ByVal lNumBytesToWrite As Long, lNumberOfBytesWritten As Long) As Integer

Public Declare Function InternetCloseHandle Lib "wininet.dll" _
    (ByVal hInternetHandle As Long) As Boolean

Public Declare Function InternetGetLastResponseInfo Lib "wininet.dll" _
    Alias "InternetGetLastResponseInfoA" _
    (ByRef lError As Long, ByVal sErrorBuffer As String, _
     ByRef lErrorBufferLength As Long) As Boolean

'error conversion to text readable message defines
Public Const FORMAT_MESSAGE_MAX_WIDTH_MASK = &HFF
Public Const FORMAT_MESSAGE_FROM_SYSTEM = &H1000
Public Const FORMAT_MESSAGE_IGNORE_INSERTS = &H200&
Public Const FORMAT_MESSAGE_FROM_HMODULE = &H800&

Public Declare Function FormatMessage Lib "kernel32" _
    Alias "FormatMessageA" _
    (ByVal dwFlags As Long, lpSource As Any, _
     ByVal dwMessageId As Long, ByVal dwLanguageId As Long, _
     ByVal lpBuffer As String, ByVal nSize As Long, _
     Arguments As Long) As Long

Public Declare Function LoadLibraryEx Lib "kernel32" _
    Alias "LoadLibraryExA" _
    (ByVal lpLibFileName As String, ByVal hFile As Long, _
    ByVal dwFlags As Long) As Long

Public Declare Function FreeLibrary Lib "kernel32" _
    (ByVal hLibModule As Long) As Long

'Version structure
Public Type OSVERSIONINFO
    dwOSVersionInfoSize As Long
    dwMajorVersion As Long
    dwMinorVersion As Long
    dwBuildNumber As Long
    dwPlatformId As Long
    szCSDVersion As String * 128        'Maintenance string for PSS usage
End Type

Public Declare Function GetVersionEx Lib "kernel32" _
    Alias "GetVersionExA" _
    (lpVersionInformation As OSVERSIONINFO) As Long

'TOC structures
Public Type TOC_TRACK
    Rsvd1 As Byte
    ADR As Byte
    Track As Byte
    Rsvd2 As Byte
    Addr(3) As Byte
End Type

Public Type TOC
    TocLen(1) As Byte
    FirstTrack As Byte
    LastTrack As Byte
    TocTrack(99) As TOC_TRACK
End Type

