' FileWatch: Beispiel fr die FileSystemWatcher-Klasse
Imports System.IO
Imports System.Console

Class App
  Shared Sub Main()
    Dim oFw As New FileSystemWatcher()
    With oFw
      .Path = "C:\Eigene Dateien"     ' Dieses Verzeichnis berwachen
      .IncludeSubdirectories = True   ' Auch Unterverzeichnisse
      .Filter = "*.*"                 ' Alle Dateien
    End With
    AddHandler oFw.Created, AddressOf OnFileMelder
    AddHandler oFw.Deleted, AddressOf OnFileMelder
    oFw.EnableRaisingEvents = True
    WriteLine("FileWatch aktiv...")
    ReadLine()
  End Sub

  Shared Sub OnFileMelder _
      (ByVal Source As Object, ByVal e As FileSystemEventArgs)
    WriteLine("Es ist was passiert... " & e.FullPath & _
              ":" & e.ChangeType.ToString)
  End Sub
End Class
