' WinHello: Anzeigen eines Formulars mit TextBox und Button
Imports System
Imports System.Drawing
Imports System.Windows.Forms

' --- Hier startet das Programm ---
Class App
  Shared Sub Main ()
    ' Neues Formular anlegen
    Dim oF As New frmHaupt()
    ' Formular anzeigen
    Application.Run (oF)
  End Sub
End Class

' --- Diese Klasse definiert das Formular ---
Public Class frmHaupt
  Inherits System.Windows.Forms.Form

  Friend WithEvents lblName  As Label
  Friend WithEvents txtName  As TextBox
  Friend WithEvents btnStart As Button

  ' --- Der Konstruktor legt das Formular mit einem ---
  ' --- Label, einer TextBox und einem Button an.   ---
  Sub New()
    MyBase.New()
    ' Caption und Gre setzen
    Me.Text = "Das ""Hallo Welt""-Programm mit Form"
    Me.ClientSize = New Size(320, 240)
    ' Ein Label erzeugen
    lblName           = New Label()
    lblName.Location  = New Point(60, 80)
    lblName.Size      = New Size(80, 20)
    lblName.Text      = "Ihr Name bitte:"
    ' Eine TextBox erzeugen
    txtName           = New TextBox()
    txtName.Location  = New Point(140, 78)
    txtName.Size      = New Size(120, 20)
    ' Einen Button erzeugen
    btnStart          = New Button()
    btnStart.Location = New Point(80, 120)
    btnStart.Size     = New Size(160, 32)
    btnStart.Text     = "Bitte hier klicken!"
    Me.Controls.AddRange(New Control() {lblName, txtName, btnStart})
  End Sub

  ' --- Die Click-Ereignisprozedur des Buttons ---
  Private Sub BtnClick(ByVal sender As Object, ByVal e As EventArgs) _
  Handles btnStart.Click
  Dim Meldung as String
    If txtName.Text = "" Then
      Meldung = "Gr Gott Unbekannter!"
    Else
      Meldung = String.Format("Gr Gott {0}!", txtName.Text)
    End If
    MessageBox.Show(Meldung, "Hallo Welt!")
  End Sub
End Class
