/* lochwuerfel.cpp by Harald Bgeholz */

#include <stdio.h>
#include <stdlib.h>
#include "lochwuerfel.h"


void Part::twist(void)
{
  int m[3][3];
  Projection xaxis;
  
  for (int i=0; i<3; ++i)
    for (int j=0; j<3; ++j)
      m[i][j] = 0;
  
  xaxis.set(0, 1, 3, 0);
  m[0][0] = 1; turn(m, 0, xaxis);
  m[0][0] = -1; turn(m, 0, xaxis);
  m[0][0] = 0;
  xaxis.set(1, 0, 3, 9);
  m[1][0] = 1; turn(m, 1, xaxis);
  m[1][0] = -1; turn(m, 1, xaxis);
  m[1][0] = 0;
  xaxis.set(1, 3, 0, 18);
  m[2][0] = 1; turn(m, 2, xaxis);
  m[2][0] = -1; turn(m, 2, xaxis);
  m[2][0] = 0;
}

void Part::turn(int m[3][3], 
                int i, const Projection& xaxis)
{
  Projection yaxis;

  if (i != 0)
    {
      yaxis.set(0, 1, 3, 0);
      m[0][1] = 1; place(m, i, xaxis, 0, yaxis);
      m[0][1] = -1; place(m, i, xaxis, 0, yaxis);
      m[0][1] = 0;
    }
  if (i != 1)
    {
      yaxis.set(1, 0, 3, 9);
      m[1][1] = 1; place(m, i, xaxis, 1, yaxis);
      m[1][1] = -1; place(m, i, xaxis, 1, yaxis);
      m[1][1] = 0;
    }
  if (i != 2)
    {
      yaxis.set(1, 3, 0, 18);
      m[2][1] = 1; place(m, i, xaxis, 2, yaxis);
      m[2][1] = -1; place(m, i, xaxis, 2, yaxis);
      m[2][1] = 0;
    }
}


void Part::place(int m[3][3], 
                 int i, const Projection& xaxis, 
                 int j, const Projection& yaxis)
{
  Projection zaxis;
  int n;

  if (i != 0 && j != 0)
    zaxis.set(0, 1, 3, 0);
  if (i != 1 && j != 1)
    zaxis.set(1, 0, 3, 9);
  if (i != 2 && j != 2)
    zaxis.set(1, 3, 0, 18);

// m[0][2]=m[1][0]*m[2][1]-m[1][1]*m[2][0];
// m[1][2]=m[0][1]*m[2][0]-m[0][0]*m[2][1];
// m[2][2]=m[0][0]*m[1][1]-m[1][0]*m[0][1];

  for (int z=0; z<3; ++z)
    for (int y=0; y<3; ++y)
      for (int x=0; x<3; ++x)
        if (0 <= x+m[0][0] && x+m[0][0] < 3 &&
            0 <= x+m[0][1] && x+m[0][1] < 3 &&
            0 <= y+m[1][0] && y+m[1][0] < 3 &&
            0 <= y+m[1][1] && y+m[1][1] < 3 &&
            0 <= z+m[2][0] && z+m[2][0] < 3 &&
            0 <= z+m[2][1] && z+m[2][1] < 3)
          {
            Bitvector bvNewPos;
            bvNewPos.set(Puzzle::pos_to_bit(x, y, z));
            bvNewPos.set(Puzzle::pos_to_bit(x+m[0][0], y+m[1][0], z+m[2][0]));
            bvNewPos.set(Puzzle::pos_to_bit(x+m[0][1], y+m[1][1], z+m[2][1]));

            Bitvector bvNewHole;
            Bitvector bvNewNonHole;

            if (hx0)
              bvNewHole.set(xaxis.to_bit(x, y, z));
            else
              bvNewNonHole.set(xaxis.to_bit(x, y, z));
            if (hx1)
              bvNewHole.set(xaxis.to_bit(x+m[0][1], y+m[1][1], z+m[2][1]));
            else
              bvNewNonHole.set(xaxis.to_bit(x+m[0][1], y+m[1][1], z+m[2][1]));
            if (hy0)
              bvNewHole.set(yaxis.to_bit(x, y, z));
            else
              bvNewNonHole.set(yaxis.to_bit(x, y, z));
            if (hy1)
              bvNewHole.set(yaxis.to_bit(x+m[0][0], y+m[1][0], z+m[2][0]));
            else
              bvNewNonHole.set(yaxis.to_bit(x+m[0][0], y+m[1][0], z+m[2][0]));
            if (hz00)
              bvNewHole.set(zaxis.to_bit(x, y, z));
            else
              bvNewNonHole.set(zaxis.to_bit(x, y, z));
            if (hz10)
              bvNewHole.set(zaxis.to_bit(x+m[0][0], y+m[1][0], z+m[2][0]));
            else
              bvNewNonHole.set(zaxis.to_bit(x+m[0][0], y+m[1][0], z+m[2][0]));
            if (hz01)
              bvNewHole.set(zaxis.to_bit(x+m[0][1], y+m[1][1], z+m[2][1]));
            else
              bvNewNonHole.set(zaxis.to_bit(x+m[0][1], y+m[1][1], z+m[2][1]));
            
            for (n=0; n<nbv; ++n)
              if (bvPos[n] == bvNewPos &&
                  bvHole[n] == bvNewHole &&
                  bvNonHole[n] == bvNewNonHole)
                break;
            if (n == nbv)
              {
                bvPos[nbv] = bvNewPos;
                bvHole[nbv] = bvNewHole;
                bvNonHole[nbv] = bvNewNonHole;
                if (++nbv > MAX_PARTPOS)
                  {
                    printf("interner Fehler: Zu viele mgliche Positionen (max=%d)\n",
                           MAX_PARTPOS);
                    exit(1);
                  }
              }
          }
}


Part::Part(bool hx0, bool hx1, bool hy0, bool hy1, 
           bool hz00, bool hz10, bool hz01)
{
  Part::hx0 = hx0; Part::hx1 = hx1;
  Part::hy0 = hy0; Part::hy1 = hy1;
  Part::hz00 = hz00; Part::hz10 = hz10; Part::hz01 = hz01;
  nbv = 0;
  twist();
  printf("Teil initialisiert: %d mgliche Lagen\n", nbv);
}


Puzzle::Puzzle(Part *parts)
{
  Puzzle::parts = parts;
  nsolutions = 0;
  for (int i=0; i<nparts; ++i)
    part_used[i] = false;
  Puzzle::parts[0].nbv = 12; // Hack, um symmetrische Lsungen auszuschlieen
}


inline int Puzzle::pos_to_bit(int x, int y, int z)
{
  return z*9 + y*3 + x;
}


void Puzzle::solve1(Bitvector bvField, Bitvector bvHole, 
                    Bitvector bvNonHole, int level)
{
  int next_bit;

  for (next_bit = 0; bvField.test(next_bit); ++next_bit)
    ; // suche das erstbeste noch nicht gesetzte Bit

  for (int part=0; part<nparts; ++part)
    if (!part_used[part])
      for (int pos=0; pos<parts[part].nbv; ++pos)
        if (parts[part].bvPos[pos].test(next_bit) &&
            !bvField.test(parts[part].bvPos[pos]) &&
            !bvHole.test(parts[part].bvNonHole[pos]) &&
            !bvNonHole.test(parts[part].bvHole[pos]))
          {
            part_used[part] = true;
            part_pos[part] = pos;
            Bitvector bvNewField = bvField;
            bvNewField.set(parts[part].bvPos[pos]);
            Bitvector bvNewHole = bvHole;
            bvNewHole.set(parts[part].bvHole[pos]);
            Bitvector bvNewNonHole = bvNonHole;
            bvNewNonHole.set(parts[part].bvNonHole[pos]);
            if (level == nparts)
              found_solution(bvNewHole);
            else
              solve1(bvNewField, bvNewHole, bvNewNonHole, level+1);
            part_used[part] = false;
          }
}


void Puzzle::found_solution(Bitvector bvHole)
{
  int x, y, z, p, i, j;

  printf("Lsung #%d gefunden:\n", ++nsolutions);

  Solution s;

  for (z=0; z<3; ++z)
    for (y=0; y<3; ++y)
      for (x=0; x<3; ++x)
        for (p=0; p<nparts; ++p)
          if (parts[p].bvPos[part_pos[p]].test(Puzzle::pos_to_bit(x, y, z)))
            {
              s.part[x][y][z] = p;
              break;
            }

  for (z=2; z>=0; --z)
    {
      for (y=2; y>=0; --y)
        {
          for (i=2; i>y; --i)
            putchar(' ');
          for (x=0; x<3; ++x)
            printf("%d", s.part[x][y][z]);
          putchar('\n');
        }
    }
  putchar('\n');

  int fmt[7][7] = 
  {
    {-1, 24, 25, 26, -1, -1, -1},
    {-1, -1, 21, 22, 23, -1, -1},
    { 8, -1, -1, 18, 19, 20, -1},
    { 5,  7, -1, -1, -1, -1, -1},
    { 2,  4,  6, -1, 15, 16, 17},
    {-1,  1,  3, -1, 12, 13, 14},
    {-1, -1,  0, -1,  9, 10, 11}
  };

  for (i=0; i<7; ++i)
    {
      for (j=0; j<7; ++j)
        {
          if (fmt[i][j] < 0)
            putchar(' ');
          else if (bvHole.test(fmt[i][j]))
            putchar('o');
          else
            putchar('.');
          putchar(' ');
        }
      putchar('\n');
    }

  putchar('\n');
}


void Puzzle::solve(void)
{
  Bitvector bvField, bvHole, bvNonHole;
  solve1(bvField, bvHole, bvNonHole, 1);
}


int main(int argc, char *argv[])
{
  printf("lochwuerfel 0.1  (C)2003 by Harald Bgeholz\n");
  Part parts[] =
  {
    Part(false, true, false, false, true, false, false),
    Part(false, false, false, true, false, true, false),
    Part(false, true, false, false, true, false, true),
    Part(false, false, true, false, false, true, false),
    Part(false, true, true, false, true, false, false),
    Part(true, false, false, true, false, false, true),
    Part(true, false, true, false, true, false, true),
    Part(false, false, false, false, false, true, true),
    Part(false, false, true, false, true, false, true)
  };
  Puzzle puzzle(parts);
  puzzle.solve();
  return 0;
}
