#!/usr/bin/perl -Tw
# Einfache Gstebuch-Demo, gaestebuch.pl

use strict;
use CGI;
use CGI::Carp qw(fatalsToBrowser);
use DBI;
  
sub main() {
  $main::dbh = DBI->connect('DBI:mysql:database=gaestebuch','gaestebuch', 'test') || 
    die("Kann nicht zur Datenbank verbinden: $!");
  if( $main::query->param('action') eq 'add' ) {
    add();
  } else {
    show();
  }
  $main::dbh->disconnect;
}

sub show() {
  print "Content-Type: text/html\n\n";
  my $sql = "SELECT id, username, eintrag FROM eintraege ORDER BY id DESC";
  my $sth = $main::dbh->prepare($sql) || die($main::dbh->errstr);
  $sth->execute() || die($main::dbh->errstr);
  print "<html><head><title>Gstebuch</title></head><body>";
  print "<h1>Gstebuch-Eintrge</h1>";
  print '<p><a href="/gaestebuch.html">Eintragen</a></p>';
  while( my $hash_ref = $sth->fetchrow_hashref ) {
    print "Name: ".$hash_ref->{'username'};
    print "<br>".$hash_ref->{'eintrag'}."<hr>\n";
  }
  print "</body></html>";
}

sub add() {
  my $sql = "INSERT INTO eintraege (username, eintrag) VALUES (?,?)";
  my $sth = $main::dbh->prepare($sql) || die($main::dbh->errstr);
  my $username = html_escape($main::query->param('username'));
  my $eintrag = html_escape($main::query->param('eintrag'));
  $sth->execute($username, $eintrag) || die($main::dbh->errstr);
  print "Location: ../cgi-bin/gaestebuch.pl?time=".time()."\n\n";
}

sub html_escape($) {
  my $s = shift;
  $s =~ s/&/&amp;/igs;
  $s =~ s/"/&quot;/igs;
  $s =~ s/'/&apos;/igs;
  $s =~ s/</&lt;/igs;
  $s =~ s/>/&gt;/igs;
  return $s;
}

$main::query = new CGI();
main();
