#undef WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <gdiplus.h>

using namespace Gdiplus;

VOID OnPaint(HDC hdc)
{
   Graphics graphics(hdc);
   Pen black(Color::Black);
   Bitmap img(L"connected_people.jpg");
   GraphicsContainer ctn = graphics.BeginContainer();
     graphics.TranslateTransform(100, 5);
     graphics.RotateTransform(30);
     graphics.DrawImage(&img, 0, 0);
   graphics.EndContainer(ctn);
   graphics.DrawRectangle(&black, 10, 10, 220, 220);
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, 
                         WPARAM wParam, LPARAM lParam)
{
   HDC          hdc;
   PAINTSTRUCT  ps;
   switch(message)
   {
   case WM_PAINT:
      hdc = BeginPaint(hWnd, &ps);
      OnPaint(hdc);
      EndPaint(hWnd, &ps);
      return 0;
   case WM_DESTROY:
      PostQuitMessage(0);
      return 0;
   default:
      return DefWindowProc(hWnd, message, wParam, lParam);
   }
}

INT WINAPI WinMain(HINSTANCE hInstance, HINSTANCE, PSTR, 
                   INT iCmdShow)
{
   HWND                hWnd;
   MSG                 msg;
   WNDCLASS            wndClass;
   GdiplusStartupInput gdiPlusInput;
   ULONG_PTR           gdiPlusToken;
   // Initialisierung von GDI+.
   Status status = GdiplusStartup(&gdiPlusToken, 
                                  &gdiPlusInput, NULL);
   if(status != Ok)
      return 0;
   wndClass.style          = CS_HREDRAW | CS_VREDRAW;
   wndClass.lpfnWndProc    = WndProc;
   wndClass.cbClsExtra     = 0;
   wndClass.cbWndExtra     = 0;
   wndClass.hInstance      = hInstance;
   wndClass.hIcon          = LoadIcon(NULL, IDI_APPLICATION);
   wndClass.hCursor        = LoadCursor(NULL, IDC_ARROW);
   wndClass.hbrBackground  = (HBRUSH)GetStockObject(WHITE_BRUSH);
   wndClass.lpszMenuName   = NULL;
   wndClass.lpszClassName  = TEXT("GDIPLUSDEMO");

   RegisterClass(&wndClass);
   hWnd = CreateWindow(TEXT("GDIPLUSDEMO"), TEXT("GDI+ Demo"), 
             WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT, 
             CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance,
             NULL);              
   ShowWindow(hWnd, iCmdShow);
   UpdateWindow(hWnd);
   while(GetMessage(&msg, NULL, 0, 0))
   {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   // GDI+ beenden.
   GdiplusShutdown(gdiPlusToken);
   return msg.wParam;
}
