#undef WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <gdiplus.h>

using namespace Gdiplus;

VOID OnPaint(HDC hdc)
{
  Graphics graphics(hdc);
  // Path mit Sechseck erzeugen
  Point points[] = {Point(50, 0), Point(150, 0), Point(200, 86),
                    Point(150, 172), Point(50, 172), Point(0, 86)};
  GraphicsPath path; 
  path.AddLines(points, 6);
  // mit Hatch-Brush fllen
  HatchStyle style = HatchStyle(HatchStyleWeave);
  HatchBrush hatchBrush(style, Color::Blue, Color::Yellow);
  graphics.TranslateTransform(20,20);
  graphics.FillPath(&hatchBrush, &path);
  // mit Linear-Brush fllen
  LinearGradientBrush linGrBrush(Point(50, 0), Point(150,172),
                                 Color::Red, Color::Blue);
  graphics.TranslateTransform(0,220);
  graphics.FillPath(&linGrBrush, &path);
  // mit Textur fllen
  Image image(L"skipover.jpg");
  TextureBrush textureBrush(&image);
  textureBrush.ScaleTransform(2,2);
  textureBrush.RotateTransform(45);
  graphics.TranslateTransform(220, -220);
  graphics.FillPath(&textureBrush, &path);
  // mit PathGradientBrush fllen
  PathGradientBrush pthGrBrush(&path);
  pthGrBrush.SetCenterColor(Color::White);
  Color colors[] = {Color::Purple, Color::Blue, Color::Green,
                    Color::Yellow, Color::Orange, Color::Red};
  int count = 6;
  pthGrBrush.SetSurroundColors(colors, &count);
  graphics.TranslateTransform(0,220);
  graphics.FillPath(&pthGrBrush, &path);
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, 
                         WPARAM wParam, LPARAM lParam)
{
   HDC          hdc;
   PAINTSTRUCT  ps;
   switch(message)
   {
   case WM_PAINT:
      hdc = BeginPaint(hWnd, &ps);
      OnPaint(hdc);
      EndPaint(hWnd, &ps);
      return 0;
   case WM_DESTROY:
      PostQuitMessage(0);
      return 0;
   default:
      return DefWindowProc(hWnd, message, wParam, lParam);
   }
}

INT WINAPI WinMain(HINSTANCE hInstance, HINSTANCE, PSTR, 
                   INT iCmdShow)
{
   HWND                hWnd;
   MSG                 msg;
   WNDCLASS            wndClass;
   GdiplusStartupInput gdiPlusInput;
   ULONG_PTR           gdiPlusToken;
   // Initialisierung von GDI+.
   Status status = GdiplusStartup(&gdiPlusToken, 
                                  &gdiPlusInput, NULL);
   if(status != Ok)
      return 0;
   wndClass.style          = CS_HREDRAW | CS_VREDRAW;
   wndClass.lpfnWndProc    = WndProc;
   wndClass.cbClsExtra     = 0;
   wndClass.cbWndExtra     = 0;
   wndClass.hInstance      = hInstance;
   wndClass.hIcon          = LoadIcon(NULL, IDI_APPLICATION);
   wndClass.hCursor        = LoadCursor(NULL, IDC_ARROW);
   wndClass.hbrBackground  = (HBRUSH)GetStockObject(WHITE_BRUSH);
   wndClass.lpszMenuName   = NULL;
   wndClass.lpszClassName  = TEXT("GDIPLUSDEMO");

   RegisterClass(&wndClass);
   hWnd = CreateWindow(TEXT("GDIPLUSDEMO"), TEXT("GDI+ Demo"), 
             WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT, 
             CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance,
             NULL);              
   ShowWindow(hWnd, iCmdShow);
   UpdateWindow(hWnd);
   while(GetMessage(&msg, NULL, 0, 0))
   {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   // GDI+ beenden.
   GdiplusShutdown(gdiPlusToken);
   return msg.wParam;
}
