package com.objectfab.ctarticle;

/**
 * Im dritten Entwurf wird generalisiert und eine Fehlerbehandlung
 * aufgenommen.
 */
public class SampleClass3 {

  /**
   * Bringt eine Dezimalzahl rechtsbuendig in einer
   * Zeichenkette vorgegebener Laenge unter. Reicht
   * der Platz nicht, wird eine Ausnahme ausgeloest.
   *
   * @param len die Laenge des String
   * @param a   die darzustellende Zahl
   * @return    der rechtsbuendig formatierte String
   */
	public String getRightAlignedIntString(int len, int a) {
		StringBuffer sb = new StringBuffer();
		String content  = Integer.toString(a);
		int numDigits   = content.length();

    if (len<numDigits) {
      throw new IllegalArgumentException("Zahl ist zu lang");
    }

		int numSpaces = len - numDigits;

		for (int i = 0; i < numSpaces; i++) {
			sb.append(" ");
		}
		sb.append(content);
		return sb.toString();
	}
}
