package com.objectfab.ctarticle;

import junit.framework.TestCase;
import junit.textui.TestRunner;

/**
 * Die Testklasse selbst implementiert das Interface, was fuer einen
 * der Tests gebraucht wird. Es ist natuerlich auch moeglich, dafuer eine
 * extra Klasse zu verwenden, jedoch sind die Mock-Funktionen so viel
 * besser zuordenbar und -- nicht zuletzt -- leichter zu implementieren.
 */
public class SampleClass4Test extends TestCase implements RowReader
{
  com.objectfab.ctarticle.SampleClass4 sample = null;

  int mockNumColumns;

  public int getRowValue(int column) {
    /* Fuer Testzwecke wird einfach die Spaltennummer zurueckgegeben.    */
    return column;
  }

  public int getNumColumns() {
    /* Fuer die Tests muss die Spaltenzahl natuerlich erst einmal gesetzt
       sein. In der setUp-Methode wird der Wert erst einmal auf drei
       festgelegt. Tests koennen das aber aber ueberschreiben, denn sie
       haben hier die Mock-Funktion unter Kontrolle.                     */
    return mockNumColumns;
  }

  public SampleClass4Test(String name) {
    super(name);
  }
  /**
   * Es ist sehr sinnvoll, die Instanz der zu testenden Klasse in einer
   * gesonderten Methode zu erzeugen. Selbst komplizierte Erzeugungsvorgaenge
   * koennen so nachgenutzt werden (Kopieren von Quelltext ist bekanntlich
   * keine Alternative).
   *
   * @return eine Instanz der zu testenden Klasse.
   * @throws Exception Wenn irgendwas schiefgeht wird das im JUnit-Framework
   * aufgefangen und als Fehler gewertet.
   */
  public com.objectfab.ctarticle.SampleClass4 createInstance() throws Exception {
    return new com.objectfab.ctarticle.SampleClass4();
  }

  /**
   *
   * @throws Exception Wenn irgendwas schiefgeht wird das im JUnit-Framework
   * aufgefangen und als Fehler gewertet.
   */
  protected void setUp() throws Exception {
    super.setUp(); // Eventuell hat die ererbte Methode noch etwas zu tun?

    sample         = createInstance(); // Der Testaufbau besteht in diesem
                                       // Beispiel nur aus einer Instanz der
                                       // zu testenden Klasse.

    mockNumColumns = 3;                // allgemeines Verhalten der Mock-
                                       // Funktion getNumColumns festlegen.
  }

  /**
   *
   * @throws Exception Wenn irgendwas schiefgeht wird das im JUnit-Framework
   * aufgefangen und als Fehler gewertet.
   */
  protected void tearDown() throws Exception {
    sample = null;    // Referenzen auf nicht mehr benutzte Instanzen
                      // werden bewusst auf null gesetzt, um es dem
                      // Garbage Collector einfacher zu machen.
    super.tearDown(); // Eventuell hat die ererbte Methode noch etwas zu tun?
  }

  public void testGetRightAlignedIntString() throws Exception {
    assertEquals("          0", sample.getRightAlignedIntString(11, 0));
    assertEquals("          1", sample.getRightAlignedIntString(11, 1));
    assertEquals("          2", sample.getRightAlignedIntString(11, 2));
    assertEquals("         10", sample.getRightAlignedIntString(11, 10));
    assertEquals("        100", sample.getRightAlignedIntString(11, 100));
    assertEquals("       1000", sample.getRightAlignedIntString(11, 1000));
    assertEquals("         -1", sample.getRightAlignedIntString(11, -1));
    assertEquals("       -999", sample.getRightAlignedIntString(11, -999));
    assertEquals(" 2147483647", sample.getRightAlignedIntString(11,
                                        Integer.MAX_VALUE));
    assertEquals("-2147483648", sample.getRightAlignedIntString(11,
                                        Integer.MIN_VALUE));

    assertEquals(   "    1", sample.getRightAlignedIntString( 5,   1));
    assertEquals("     -10", sample.getRightAlignedIntString( 8, -10));

    try {
      String buffer=sample.getRightAlignedIntString(10, Integer.MIN_VALUE );
      fail("Es sollte eine Exception geworfen werden (buffer="+buffer+")");
    } catch (IllegalArgumentException e) {
      // Alles in Ordnung
    }
  }

  /**
   *
   * @throws Exception Wenn irgendwas schiefgeht wird das im JUnit-Framework
   * aufgefangen und als Fehler gewertet.
   */
  public void testGetRowString() throws Exception {

    assertEquals("012",       sample.getRowString(this, 1));
    assertEquals(" 0 1 2",    sample.getRowString(this, 2));
    assertEquals("  0  1  2", sample.getRowString(this, 3));

    mockNumColumns = 0;
    assertEquals("",          sample.getRowString(this, 3));

    mockNumColumns = 1;
    assertEquals("   0",      sample.getRowString(this, 4));
  }

  /**
   * Die main-Methode ist in TestCases sehr hilfreich, um diese Tests
   * direkt auf der Kommandozeile auszufuehren. Sie erspart Schreibarbeit,
   * mehr macht sie nicht.
   * @param args die Kommandozeilenparameter (keine)
   */
  public static void main(String[] args) {
    junit.textui.TestRunner.run(SampleClass4Test.class);
  }
}
