#!/usr/bin/perl -w

# $Id$

use strict;
use HTML::Entities;
use MIME::Base64;
use Net::SMTP;
use LWP;
use LWP::Debug qw(+);

# Configuration
my $uname     = 'xxx';   # change to your t-online name
my $pword     = 'xxx';   # change to your password
my $localname = 'xxx';   # change to your local name
my $deliver   = 'mbox';  # change to 'smtp', if Hamster or
                         # <yourfavoriteunixsmtpserver>
                         # is running on the same machine

my $url   = 'https://webmail.t-online.de';
my $ua    = LWP::UserAgent->new();
my $spool = '/var/spool/mail/';

my $location = createLogin( $ua, $url, $uname, $pword );

# Comment out the first line an uncomment the second to fetch the "Ablage" folder
my $inbox = $ua->get("$location/main.cgp");
#my $inbox      = $ua->get("$location/stor.cgp");
my @ids = grepIDs($inbox);

for ( my $i = 0 ; $i < @ids ; $i++ ) {
    my $html = fetchMail( $location, $ids[$i] );
    my $mail = makeMail( $html,      $location );
    my $issave = fileMail( $mail, $spool, $localname );

    if ($issave) {
        # deleteMail($location, $ids[$i], $i);
        # it's commented out, but: BE CAREFUL - please, save FIRST.
    }

    sleep(2);  # don't kill webservers with too fast polls
} ## end for ( my $i =...

$ua->get( $url . "/logout.cgp" );

sub createLogin {
    my ( $ua, $url, $uname, $pword ) = @_;

    my $location;
    my $form_login;
    my $form_pass;
    my $form;
    my $id;
    my $resp;

    push @{ $ua->requests_redirectable() }, 'POST';

    $form = $ua->get($url) or die "Couldn't fetch $url";
    die $form->message() if $form->is_error();

    ($id) = $form->content() =~ m{/([^/]+)/login_in_frame\.cgp}s;

    $form_login = $id . "log1n";
    $form_pass  = $id . "passw8rd";

    $resp = $ua->post(
        $url . "/main.cgp",
        [
            $form_login => $uname,
            $form_pass  => $pword,
            'js'        => '0',
            'sessionid' => $id
        ]
    );

    if ( $resp->is_redirect() ) {
        ($location) =
          ( $resp->headers()->{'location'} =~ m/(https.+?)main.cgp/ );
      return $location;
    }
    else {
        print "Couldn't get redirection URL - maybe form changed.\n";
        print "Status was: " . $resp->status_line() . "\n";
    }

} ## end sub createLogin

sub grepIDs {
    my $mbox = shift;
    my %ids;

    foreach my $key ( $mbox->content() =~ m/MAIL=(\d+?)\"/sg ) {
        $ids{$key} = 1;
    }

  return keys(%ids);
} ## end sub grepIDs

sub fetchMail {
    my ( $url, $id ) = @_;
    my $mail = $ua->get( $url . "read.cgp?MAIL=" . $id . "&HEADER=1" );

  return $mail->content();
} ## end sub fetchMail

sub makeMail {
    my ( $html, $url ) = @_;
    my $attachment;
    my @attachments;
    my $mail;

    my ( $header, $body, $txt ) = $html =~ m{<tt>(.+?)</tt>}sg;

    $header = buildHeader($header);

    unless ( $header =~ m/Content-Type: text\/html/i ) {
        $body = deHTML($body);
    }

    if ( $header =~ m/boundary=\"(.+?)\"/ ) {
        my $boundary  = $1;
        my $boundbody =
          "--$boundary\n"
          . "Content-Type: text/plain; charset=\"iso-8859-1\"\n"
          . "Content-transfer-Encoding: 8bit\n";

        @attachments = createAttachments( $boundary, $url, $txt, $html );

        foreach (@attachments) {
            $attachment .= $_;
        }

        $mail = $header
          . $boundbody
          . $body
          . $attachment . "--"
          . $boundary
          . "--\n\n";
    } ## end if ( $header...
    else {
        $mail = $header . $body;
    }

  return $mail;
} ## end sub makeMail

sub createAttachments
# for better attachment-handling, use MIME::Lite or create your own function.
# This function just satisfies the absolut minimal requirements and is a dirty
# hack.
{
    my ( $boundary, $url, $txt, $html ) = @_;
    my $resp;
    my $attachhead;
    my $attachbody;
    my $attachment;
    my @attachments;

    my @attachlinks = ( $html =~ m/<a href="(storeattachment\/.+?)">/sg );

    foreach my $link (@attachlinks) {
        ( my $file ) = ( $link =~ m/storeattachment\/(.+?)\?/ );

        if ( $file =~ m/(jpe?g|gif|tiff?|png)/i ) {
            $attachhead =
              "--$boundary\n"
              . "Content-Type: application/$1\n"
              . "Content-Disposition: attachment; filename=\"$file\"\n"
              . "Content-Transfer-Encoding: base64\n\n";

            $resp       = $ua->get( $url . $link );
            $attachbody = encode_base64( $resp->content() );
        } ## end if ( $file =~...
        elsif ( $file =~ m/(pdf|doc|pgp|ps)/i ) {
            $attachhead =
              "--$boundary\n"
              . "Content-Type: application/$1\n"
              . "Content-Disposition: attachment; filename=\"$file\"\n"
              . "Content-Transfer-Encoding: base64\n\n";

            $resp       = $ua->get( $url . $link );
            $attachbody = encode_base64( $resp->content() );
        } ## end elsif ( $file =~...
        elsif ($file) {
            $attachhead =
              "--$boundary\n"
              . "Content-Type: application/*\n"
              . "Content-Disposition: attachment; filename=\"$file\"\n"
              . "Content-Transfer-Encoding: base64\n\n";

            $resp       = $ua->get( $url . $link );
            $attachbody = encode_base64( $resp->content() );
        } ## end elsif ($file)
        elsif ( ( !$file ) && $txt ) {
            $attachhead =
              "--$boundary\n"
              . "Content-Type: text/plain; charset=ISO-8859-1\n"
              . "Content-Transfer-Encoding: base64\n\n";

            $txt        = deHTML($txt);
            $attachbody = encode_base64($txt);
        } ## end elsif ( ( !$file...

        $attachment = $attachhead . $attachbody . "\n\n";
        push ( @attachments, $attachment );
    } ## end foreach my $link ...

  return @attachments;
} ## end sub createAttachments

sub deHTML {
    my $content = shift;

    $content =~ s/<[^>]+>//g;
    $content =~ s/\&#160;/ /g;
    $content = decode_entities($content);

  return $content;
} ## end sub deHTML

sub buildHeader
# creates From: - header for mbox format recognition.
{
    my $crap = shift;
    my $clean;
    my $from;
    my $date;
    my $header;
    my @field;

    $clean = deHTML($crap);

    if ( $deliver eq 'smtp' ) {
      return $clean;
    }

    ($from) = ( $clean =~ m/From:.+<(.+?)>/ );
    ($date) = ( $clean =~ m/Date: (.+)/ );

    @field = split ( / /, $date );
    chop $field[0];
    $date = "$field[0] $field[2] $field[1] $field[4] $field[3]";

    $from = "From " . $from . " " . $date;

    $header = $from . $clean;
    $header =~ s/ +(From.+$)/$1/g;

  return $header;
} ## end sub buildHeader

sub deleteMail {
    my ( $url, $id, $count ) = @_;
    my $resp =
      $ua->get( $url . "main.cgp?MAIL[$count]=" . $id . "&Loeschen.x=1" );

  return 0 unless ( $resp->status_line() =~ /OK/ );
} ## end sub deleteMail

sub fileMail {
    my ( $mail, $spool, $localname ) = @_;

    if ( $deliver eq 'smtp' ) {
        my ($from) = ( $mail =~ m/From: .+?<([^<]+)>/ );
        my $smtp = Net::SMTP->new('localhost')
          or die "Can't connect SMTP localhost!\n";

        $smtp->mail($from);
        $smtp->to($localname);
        $smtp->data();
        $smtp->datasend($mail);
        $smtp->dataend();
        $smtp->quit;

      return 1;
    } ## end if ( $deliver...
    elsif ( $deliver eq 'mbox' ) {
        open( MBOX, ">>$spool$localname" )
          or die "Can't open Mailbox of $localname!\n";
        print MBOX $mail;
        close MBOX;
      return 1;
    } ## end elsif ( $deliver...
    else {
      return 0;
    }
} ## end sub fileMail

sub fetchFile
# fetches via t-online the complete mail with headers and attachments as file. The file
# isn't compatible to mbox. Please, adjust by yourself.
# Create a unique ID at the main for-loop - just the content is
# returned by this function, the filename has to be done by yourself.
{
    my ( $url, $mail_id ) = @_;
    my $resp =
      $ua->get( $url
          . "main.cgp?MAIL[0]="
          . $mail_id
          . "&Speichern.x=1&Speichern.y=1" );
    my $mail;

    if ( $resp->is_redirect() ) {
        my $mail = $ua->get( $resp->headers()->{'location'} );
      return $mail->content();
    }
} ## end sub fetchFile

