package de.ct.refactoring;

import junit.framework.TestCase;

/**
 * Der Unit-Test prft alle Klassen des Beispiels zugleich
 * Zum Compilieren und Starten bentigt man das
 * JUnit-Framework (www.junit.org)
 */
public class RefactoringExample1Test extends TestCase {

	public RefactoringExample1Test(String arg0) {
		super(arg0);
	}

	public void testEmptyString() {
		assertEqualsLongestRepeatingSubstring("", "");
		assertEqualsLongestRepeatingSubstring("", " ");
		assertEqualsLongestRepeatingSubstring(" ", "  ");
		assertEqualsLongestRepeatingSubstring("  ", "   ");
	}

	public void testOneRepetition() {
		assertEqualsLongestRepeatingSubstring("", "a");
		assertEqualsLongestRepeatingSubstring("a", "aa");
		assertEqualsLongestRepeatingSubstring("a", "aba");
		assertEqualsLongestRepeatingSubstring("a", "abba");
		assertEqualsLongestRepeatingSubstring("a", "aab");
		assertEqualsLongestRepeatingSubstring("a", "baa");
		assertEqualsLongestRepeatingSubstring("a", "baab");
	}

	public void testMultipleRepetition(){
		assertEqualsLongestRepeatingSubstring("aa", "aaa");
		assertEqualsLongestRepeatingSubstring("ab", "abab");
		assertEqualsLongestRepeatingSubstring("abab", "ababab");
		assertEqualsLongestRepeatingSubstring("aa", "aaabbb");
		assertEqualsLongestRepeatingSubstring("aa", "bbbaaa");
	}

	public void testExample() {
		assertEqualsLongestRepeatingSubstring("issi", "Mississippi");
	}

	private void assertEqualsLongestRepeatingSubstring(String expected, String actual){
		assertEquals(expected, RefactoringExample1.StringRetLongestRepeatingSubstring(actual));
		assertEquals(expected, RefactoringExample2.longestRepeatingSubstring(actual));
		assertEquals(expected, RefactoringExample3.longestRepeatingSubstring(actual));
		assertEquals(expected, RefactoringExample4.longestRepeatingSubstring(actual));
		assertEquals(expected, RefactoringExample5.longestRepeatingSubstring(actual));
	   assertEquals(expected, RefactoringExample6.longestRepeatingSubstring(actual));
	   assertEquals(expected, RefactoringExample7.longestRepeatingSubstring(actual));
  }
}